/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.brandonscore.inventory.SlotCheckValid;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerJunkFilter
extends Container {
    private final ItemStack stack;
    private final EntityPlayer player;
    private final PlayerSlot slot;
    private final IItemHandler itemHandler;

    public ContainerJunkFilter(EntityPlayer player, PlayerSlot slot, IItemHandler itemHandler) {
        this.player = player;
        this.slot = slot;
        this.itemHandler = itemHandler;
        this.stack = slot.getStackInSlot(player);
        this.addPlayerSlots(8, 29 + itemHandler.getSlots() / 9 * 18, 4);
        this.addJunkSlots(8, 21);
    }

    public void func_75142_b() {
        if (this.stack != this.slot.getStackInSlot(this.player) && !this.player.field_70170_p.field_72995_K) {
            this.player.func_71053_j();
        }
        super.func_75142_b();
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId < this.field_75151_b.size() && ((Slot)this.field_75151_b.get(slotId)).func_75211_c() == this.stack) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @Nullable
    public ItemStack func_82846_b(EntityPlayer playerIn, int i) {
        Slot slot = this.func_75139_a(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack result = stack.func_77946_l();
            if (i >= 36 ? !this.func_75135_a(stack, 0, 36, false) : !this.func_75135_a(stack, 36, 36 + this.itemHandler.getSlots(), false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_190901_a(this.player, stack);
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        Slot slot = this.func_75139_a(slotID);
        if (slot != null) {
            slot.func_75215_d(stack);
        }
    }

    public Slot func_75139_a(int slotId) {
        if (slotId < this.field_75151_b.size() && slotId >= 0) {
            return (Slot)this.field_75151_b.get(slotId);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            Slot slot = this.func_75139_a(i);
            if (slot == null) continue;
            slot.func_75215_d(stacks.get(i));
        }
    }

    public void addPlayerSlots(int posX, int posY, int hotbarSpacing) {
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a((Slot)new SlotCheckValid((IInventory)this.player.field_71071_by, x, posX + 18 * x, posY + 54 + hotbarSpacing));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new SlotCheckValid((IInventory)this.player.field_71071_by, x + y * 9 + 9, posX + 18 * x, posY + y * 18));
            }
        }
    }

    public void addJunkSlots(int posX, int posY) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int x = i % 9 * 18;
            int y = i / 9 * 18;
            this.func_75146_a((Slot)new SlotItemHandler(this.itemHandler, i, posX + x, posY + y));
        }
    }
}

