/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.beans.ConstructorProperties;
import net.minecraft.util.math.Vec3i;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.SizeValidators;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class ExactSizeValidator
implements ISizeValidator {
    private final Vec3i exactSize;

    @Override
    public L10NHelpers.UnlocalizedString isSizeValid(Vec3i size) {
        if (SizeValidators.compareVec3i(size, this.getExactSize()) == 0) {
            return null;
        }
        return new L10NHelpers.UnlocalizedString("multiblock.cyclopscore.error.size.exact", LocationHelpers.toCompactString(size), LocationHelpers.toCompactString(this.getExactSize()));
    }

    @ConstructorProperties(value={"exactSize"})
    public ExactSizeValidator(Vec3i exactSize) {
        this.exactSize = exactSize;
    }

    public Vec3i getExactSize() {
        return this.exactSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExactSizeValidator)) {
            return false;
        }
        ExactSizeValidator other = (ExactSizeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vec3i this$exactSize = this.getExactSize();
        Vec3i other$exactSize = other.getExactSize();
        return !(this$exactSize == null ? other$exactSize != null : !this$exactSize.equals(other$exactSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExactSizeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vec3i $exactSize = this.getExactSize();
        result = result * 59 + ($exactSize == null ? 0 : $exactSize.hashCode());
        return result;
    }

    public String toString() {
        return "ExactSizeValidator(exactSize=" + this.getExactSize() + ")";
    }
}

