/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.entity.EntityTFCubeOfAnnihilation;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFCubeOfAnnihilation
extends ItemTF {
    private static final String THROWN_UUID_KEY = "cubeEntity";

    protected ItemTFCubeOfAnnihilation() {
        this.field_77777_bU = 1;
        this.func_77637_a(TFItems.creativeTab);
        this.func_185043_a(new ResourceLocation("twilightforest", "thrown"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemTFCubeOfAnnihilation.getThrownUuid(stack) != null ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity holder, int slot, boolean isSelected) {
        if (!world.field_72995_K && ItemTFCubeOfAnnihilation.getThrownUuid(stack) != null && ItemTFCubeOfAnnihilation.getThrownEntity(world, stack) == null) {
            stack.func_77978_p().func_82580_o("cubeEntityMost");
            stack.func_77978_p().func_82580_o("cubeEntityLeast");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemTFCubeOfAnnihilation.getThrownUuid(stack) != null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            EntityTFCubeOfAnnihilation launchedCube = new EntityTFCubeOfAnnihilation(world, (EntityLivingBase)player);
            world.func_72838_d((Entity)launchedCube);
            ItemTFCubeOfAnnihilation.setThrownEntity(stack, launchedCube);
        }
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    private static UUID getThrownUuid(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(THROWN_UUID_KEY)) {
            return stack.func_77978_p().func_186857_a(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private static EntityTFCubeOfAnnihilation getThrownEntity(World world, ItemStack stack) {
        Entity e;
        UUID id;
        if (world instanceof WorldServer && (id = ItemTFCubeOfAnnihilation.getThrownUuid(stack)) != null && (e = ((WorldServer)world).func_175733_a(id)) instanceof EntityTFCubeOfAnnihilation) {
            return (EntityTFCubeOfAnnihilation)e;
        }
        return null;
    }

    private static void setThrownEntity(ItemStack stack, EntityTFCubeOfAnnihilation cube) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_186854_a(THROWN_UUID_KEY, cube.func_110124_au());
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return true;
    }
}

