/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFConfig;
import twilightforest.TFTeleporter;
import twilightforest.block.TFBlocks;

public class BlockTFPortal
extends BlockBreakable {
    public static final IProperty<Boolean> DISALLOW_RETURN = PropertyBool.func_177716_a((String)"is_one_way");
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_ITEM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.4f, 1.0);
    private static final int PORTAL_SIZE_LIMIT = 64;

    public BlockTFPortal() {
        super(Material.field_151567_E, false);
        this.func_149711_c(-1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DISALLOW_RETURN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DISALLOW_RETURN});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b(DISALLOW_RETURN) != false ? 1 : 0;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DISALLOW_RETURN, (Comparable)Boolean.valueOf(meta == 1));
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b(DISALLOW_RETURN) != false ? AABB : field_185506_k;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBB, List<AxisAlignedBB> blockBBs, @Nullable Entity entity, boolean isActualState) {
        BlockTFPortal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBB, blockBBs, (AxisAlignedBB)(entity != null && entity instanceof EntityItem ? AABB_ITEM : state.func_185890_d((IBlockAccess)world, pos)));
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean tryToCreatePortal(World world, BlockPos pos, EntityItem activationItem) {
        IBlockState state = world.func_180495_p(pos);
        if (state == Blocks.field_150355_j.func_176223_P() || state.func_177230_c() == this && ((Boolean)state.func_177229_b(DISALLOW_RETURN)).booleanValue()) {
            HashMap<BlockPos, Boolean> blocksChecked = new HashMap<BlockPos, Boolean>();
            blocksChecked.put(pos, true);
            MutableInt size = new MutableInt(0);
            if (BlockTFPortal.recursivelyValidatePortal(world, pos, blocksChecked, size, state) && size.get() > 3) {
                activationItem.func_92059_d().func_190918_g(1);
                BlockTFPortal.causeLightning(world, pos, TFConfig.portalLightning);
                for (Map.Entry<BlockPos, Boolean> checkedPos : blocksChecked.entrySet()) {
                    if (!checkedPos.getValue().booleanValue()) continue;
                    world.func_180501_a(checkedPos.getKey(), TFBlocks.portal.func_176223_P(), 2);
                }
                return true;
            }
        }
        return false;
    }

    private static void causeLightning(World world, BlockPos pos, boolean fake) {
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, fake);
        world.func_72942_c((Entity)bolt);
        if (fake) {
            double range = 3.0;
            List list = world.func_72872_a(Entity.class, new AxisAlignedBB(pos).func_186662_g(range));
            for (Entity victim : list) {
                if (ForgeEventFactory.onEntityStruckByLightning((Entity)victim, (EntityLightningBolt)bolt)) continue;
                victim.func_70077_a(bolt);
            }
        }
    }

    private static boolean recursivelyValidatePortal(World world, BlockPos pos, HashMap<BlockPos, Boolean> blocksChecked, MutableInt waterLimit, IBlockState requiredBlockFor) {
        boolean isPoolProbablyEnclosed = true;
        waterLimit.increment();
        if (waterLimit.get() > 64) {
            return false;
        }
        for (int i = 0; i < EnumFacing.field_176754_o.length && waterLimit.get() <= 64; ++i) {
            BlockPos positionCheck = pos.func_177972_a(EnumFacing.field_176754_o[i]);
            if (blocksChecked.containsKey(positionCheck)) continue;
            IBlockState state = world.func_180495_p(positionCheck);
            if (state == requiredBlockFor && world.func_180495_p(positionCheck.func_177977_b()).func_185917_h()) {
                blocksChecked.put(positionCheck, true);
                isPoolProbablyEnclosed = isPoolProbablyEnclosed && BlockTFPortal.recursivelyValidatePortal(world, positionCheck, blocksChecked, waterLimit, requiredBlockFor);
                continue;
            }
            if (BlockTFPortal.isGrassOrDirt(state) && BlockTFPortal.isNatureBlock(world.func_180495_p(positionCheck.func_177984_a())) || state.func_177230_c() == TFBlocks.uberous_soil) {
                blocksChecked.put(positionCheck, false);
                continue;
            }
            return false;
        }
        return isPoolProbablyEnclosed;
    }

    private static boolean isNatureBlock(IBlockState state) {
        Material mat = state.func_185904_a();
        return mat == Material.field_151585_k || mat == Material.field_151582_l || mat == Material.field_151584_j;
    }

    private static boolean isGrassOrDirt(IBlockState state) {
        Material mat = state.func_185904_a();
        return state.func_185917_h() && (mat == Material.field_151577_b || mat == Material.field_151578_c);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block notUsed, BlockPos fromPos) {
        boolean good = world.func_180495_p(pos.func_177977_b()).func_185917_h();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!good) break;
            IBlockState neighboringState = world.func_180495_p(pos.func_177972_a(facing));
            good = BlockTFPortal.isGrassOrDirt(neighboringState) || neighboringState == state;
        }
        if (!good) {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (state == this.func_176223_P()) {
            BlockTFPortal.attemptSendPlayer(entity, false);
        }
    }

    public static void attemptSendPlayer(Entity entity, boolean forcedEntry) {
        if (entity.field_70128_L || entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU()) {
            return;
        }
        if (!forcedEntry && entity.field_71088_bW > 0) {
            return;
        }
        entity.field_71088_bW = 10;
        int destination = entity.field_71093_bK != TFConfig.dimension.dimensionID ? TFConfig.dimension.dimensionID : 0;
        entity.changeDimension(destination, (ITeleporter)TFTeleporter.getTeleporterForDim(entity.func_184102_h(), destination));
        if (destination != 0 && entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            playerMP.setSpawnChunk(new BlockPos((Entity)playerMP), true, TFConfig.dimension.dimensionID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int random = rand.nextInt(100);
        if (((Boolean)stateIn.func_177229_b(DISALLOW_RETURN)).booleanValue() && random < 80) {
            return;
        }
        if (random == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double xPos = (float)pos.func_177958_n() + rand.nextFloat();
            double yPos = (double)pos.func_177956_o() + 1.0;
            double zPos = (float)pos.func_177952_p() + rand.nextFloat();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = rand.nextFloat();
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed, new int[0]);
        }
    }

    private static class MutableInt {
        private int anInt;

        MutableInt(int anInt) {
            this.anInt = anInt;
        }

        int get() {
            return this.anInt;
        }

        void increment() {
            ++this.anInt;
        }
    }
}

