/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.mekores.item;

import io.github.phantamanta44.mekores.MekOres;
import io.github.phantamanta44.mekores.item.MOItems;
import io.github.phantamanta44.mekores.item.base.ItemModSubs;
import io.github.phantamanta44.mekores.ore.OreStage;
import io.github.phantamanta44.mekores.ore.OreType;
import io.github.phantamanta44.mekores.ore.SpecificOreStage;
import io.github.phantamanta44.mekores.util.GasHelper;
import io.github.phantamanta44.mekores.util.IMCHelper;
import io.github.phantamanta44.mekores.util.OreDictHelper;
import java.util.Arrays;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMekanismOre
extends ItemModSubs {
    private static SpecificOreStage[] registry;

    public static SpecificOreStage getStage(ItemStack stack) {
        return registry[stack.func_77960_j()];
    }

    private static int buildRegistry() {
        registry = (SpecificOreStage[])Arrays.stream(OreType.values()).peek(GasHelper::registerOreGas).flatMap(t -> Arrays.stream(OreStage.values()).map(s -> new SpecificOreStage((OreType)((Object)t), (OreStage)((Object)((Object)s))))).toArray(SpecificOreStage[]::new);
        return registry.length;
    }

    ItemMekanismOre() {
        super("mekanismOre", ItemMekanismOre.buildRegistry());
        block7: for (int i = 0; i < registry.length; ++i) {
            SpecificOreStage stage = registry[i];
            switch (stage.stage) {
                case CRYSTAL: {
                    MekOres.PROXY.registerItemModel(this, i, "crystal");
                    continue block7;
                }
                case SHARD: {
                    MekOres.PROXY.registerItemModel(this, i, "shard");
                    continue block7;
                }
                case CLUMP: {
                    MekOres.PROXY.registerItemModel(this, i, "clump");
                    continue block7;
                }
                case DIRTY_DUST: {
                    MekOres.PROXY.registerItemModel(this, i, "dirty_dust");
                    continue block7;
                }
                case DUST: {
                    MekOres.PROXY.registerItemModel(this, i, "dust");
                }
            }
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == MOItems.CREATIVE_TAB) {
            for (int i = 0; i < this.subs; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                if (!ItemMekanismOre.getStage(stack).isValid()) continue;
                subItems.add((Object)stack);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return ItemMekanismOre.getStage(stack).getLocalizedName();
    }

    public void registerOreDict() {
        for (int i = 0; i < registry.length; ++i) {
            ItemStack stack = new ItemStack((Item)this, 1, i);
            SpecificOreStage stage = ItemMekanismOre.getStage(stack);
            if (!stage.isValid()) continue;
            OreDictionary.registerOre((String)stage.getEntry(), (ItemStack)stack);
        }
    }

    public void registerRecipes() {
        for (OreType type : OreType.values()) {
            if (!type.isValid()) continue;
            try {
                ItemStack ingotStack;
                NonNullList ores = OreDictionary.getOres((String)("ore" + type.key));
                Gas hCl = GasRegistry.getGas((String)"hydrogenchloride");
                Gas oxygen = GasRegistry.getGas((String)"oxygen");
                for (ItemStack stack : ores) {
                    IMCHelper.addChemicalDissolutionRecipe(stack, GasHelper.gasStack(type.getName(), 1000));
                }
                IMCHelper.addChemicalWasherRecipe(GasHelper.gasStack(type.getName(), 1), GasHelper.gasStack("clean" + type.getName(), 1));
                IMCHelper.addChemicalCrystalizationRecipe(GasHelper.gasStack("clean" + type.getName(), 200), OreStage.CRYSTAL.oreForType(type, 1));
                IMCHelper.addChemicalInjectionRecipe(OreStage.CRYSTAL.oreForType(type, 1), hCl, OreStage.SHARD.oreForType(type, 1));
                for (ItemStack stack : ores) {
                    IMCHelper.addChemicalInjectionRecipe(stack, hCl, OreStage.SHARD.oreForType(type, 4));
                }
                IMCHelper.addPurificationRecipe(OreStage.SHARD.oreForType(type, 1), oxygen, OreStage.CLUMP.oreForType(type, 1));
                for (ItemStack stack : ores) {
                    IMCHelper.addPurificationRecipe(stack, oxygen, OreStage.CLUMP.oreForType(type, 3));
                }
                IMCHelper.addCrusherRecipe(OreStage.CLUMP.oreForType(type, 1), OreStage.DIRTY_DUST.oreForType(type, 1));
                IMCHelper.addEnrichmentRecipe(OreStage.DIRTY_DUST.oreForType(type, 1), OreStage.DUST.oreForType(type, 1));
                for (ItemStack stack : ores) {
                    IMCHelper.addEnrichmentRecipe(stack, OreStage.DUST.oreForType(type, 2));
                }
                NonNullList dusts = OreDictionary.getOres((String)OreStage.DUST.getEntry(type.key));
                if (!dusts.stream().allMatch(is -> is.func_77973_b() instanceof ItemMekanismOre) || (ingotStack = OreDictHelper.getStack("ingot" + type.key, 1)) == null) continue;
                GameRegistry.addSmelting((ItemStack)OreStage.DUST.oreForType(type, 1), (ItemStack)ingotStack, (float)0.0f);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register recipes for ore: " + (Object)((Object)type), e);
            }
        }
    }
}

