/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipeManager;
import com.blakebr0.extendedcrafting.item.ItemSingularity;
import com.blakebr0.extendedcrafting.item.ItemSingularityUltimate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class ItemSingularityCustom
extends ItemMeta
implements IModelHelper,
IEnableable {
    public static ArrayList<CustomSingularity> singularities = new ArrayList();
    public static Map<Integer, Integer> singularityColors = new HashMap<Integer, Integer>();
    public static Map<Integer, Object> singularityMaterials = new HashMap<Integer, Object>();
    private Configuration config = ModConfig.config;

    public ItemSingularityCustom() {
        super("ec.singularity_custom", ExtendedCrafting.REGISTRY);
        this.func_77637_a(ExtendedCrafting.CREATIVE_TAB);
    }

    public String func_77653_i(ItemStack stack) {
        String name = this.items.containsKey(stack.func_77960_j()) ? ((ItemMeta.MetaItem)this.items.get(stack.func_77960_j())).getName().replace("_", " ") : "Dummy";
        return WordUtils.capitalize((String)name) + " " + Utils.localize((String)"item.ec.singularity.name");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void configure(Configuration config) {
        ConfigCategory category = config.getCategory("singularity");
        String[] values = config.get(category.getName(), "custom_singularities", new String[0]).getStringList();
        category.get("custom_singularities").setComment("Here you can add your own custom Singularities.\n- Syntax: meta;name;material;color\n- Example: 12;super_potato;minecraft:carrot;123456\n- 'meta' must be different for each, and should not be changed.\n- 'name' should be lower case with underscores for spaces. Singularity is added automatically.\n- Example: 'lots_of_spaghetti' would show 'Lots Of Spaghetti Singularity'.\n- 'material' is an item id or ore dictionary entry. This is for the generic crafting recipe.\n- Note: if you plan on adding your own recipe with the CraftTweaker integration, put 'none'.\n- Examples: 'minecraft:stone' for stone, 'ore:ingotIron' for the ore dictionary entry 'ingotIron'.\n- Note: you can also specify meta for item ids, by adding them to the end of the item id.\n- Example: minecraft:stone:3 for a meta of 3. Make the meta 32767 for wildcard value.\n- 'color' the color of the singularity as a hex value. http://htmlcolorcodes.com/\n- Example: 123456 would color it as whatever that color is.");
        for (String value : values) {
            int color;
            int meta;
            String[] parts = value.split(";");
            if (parts.length != 4) {
                ExtendedCrafting.LOGGER.error("Invalid custom singularity syntax length: " + value);
                continue;
            }
            String name = parts[1];
            String material = parts[2];
            try {
                meta = Integer.valueOf(parts[0]);
                color = Integer.parseInt(parts[3], 16);
            }
            catch (NumberFormatException e) {
                ExtendedCrafting.LOGGER.error("Invalid custom singularity syntax ints: " + value);
                continue;
            }
            singularities.add(new CustomSingularity(meta, name, material, color));
        }
    }

    public void init() {
        for (CustomSingularity sing : singularities) {
            this.addSingularity(sing.meta, sing.name, sing.material, sing.color);
        }
    }

    public void initModels() {
        for (Map.Entry item : this.items.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)item.getKey()), (ModelResourceLocation)ResourceHelper.getModelResource((String)"extendedcrafting", (String)"singularity", (String)"inventory"));
        }
    }

    public boolean isEnabled() {
        return ModConfig.confSingularityEnabled;
    }

    public ItemStack addSingularity(int meta, String name, String material, int color) {
        singularityColors.put(meta, color);
        singularityMaterials.put(meta, material);
        ItemSingularityUltimate.addSingularityToRecipe(new ItemStack((Item)this, 1, meta));
        return this.addItem(meta, name, true);
    }

    public void initRecipes() {
        if (!this.isEnabled()) {
            return;
        }
        for (Map.Entry<Integer, Object> obj : singularityMaterials.entrySet()) {
            Object value = obj.getValue();
            int meta = obj.getKey();
            Item item = null;
            ItemStack stack = ItemStack.field_190927_a;
            if (value instanceof String) {
                if ("none".equalsIgnoreCase((String)value)) continue;
                String[] parts = ((String)value).split(":");
                int matMeta = 0;
                if (parts.length == 3) {
                    try {
                        matMeta = Integer.valueOf(parts[2]);
                    }
                    catch (NumberFormatException e) {
                        ExtendedCrafting.LOGGER.error("Invalid meta for singularity: " + value.toString());
                        continue;
                    }
                    item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]));
                    stack = new ItemStack(item, 1, matMeta);
                    if (stack.func_190926_b()) continue;
                    CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), stack.func_77946_l(), ModConfig.confSingularityAmount, ItemSingularity.getCatalystStack(), false, ModConfig.confSingularityRF);
                    continue;
                }
                if (parts.length == 2) {
                    if (((String)value).startsWith("ore:")) {
                        String ore = ((String)value).substring(4);
                        if (!OreDictionary.doesOreNameExist((String)ore) || OreDictionary.getOres((String)ore).isEmpty()) continue;
                        CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), ore, ModConfig.confSingularityAmount, ItemSingularity.getCatalystStack(), false, ModConfig.confSingularityRF);
                        continue;
                    }
                    item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]));
                    stack = new ItemStack(item);
                    if (stack.func_190926_b()) continue;
                    CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), stack.func_77946_l(), ModConfig.confSingularityAmount, ItemSingularity.getCatalystStack(), false, ModConfig.confSingularityRF);
                    continue;
                }
                ExtendedCrafting.LOGGER.error("Invalid material for singularity: " + value.toString());
                continue;
            }
            ExtendedCrafting.LOGGER.error("Invalid material for singularity: " + value.toString());
        }
    }

    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            return singularityColors.get(stack.func_77960_j());
        }
    }

    public class CustomSingularity {
        public int meta;
        public String name;
        public String material;
        public int color;

        public CustomSingularity(int meta, String name, String material, int color) {
            this.meta = meta;
            this.name = name;
            this.material = material;
            this.color = color;
        }
    }
}

