/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.gui;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.client.container.ContainerCompressor;
import com.blakebr0.extendedcrafting.network.EjectModeSwitchPacket;
import com.blakebr0.extendedcrafting.network.NetworkThingy;
import com.blakebr0.extendedcrafting.tile.TileCompressor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCompressor
extends GuiContainer {
    private static final ResourceLocation GUI = ResourceHelper.getResource((String)"extendedcrafting", (String)"textures/gui/compressor.png");
    private TileCompressor tile;

    public GuiCompressor(TileCompressor tile, ContainerCompressor container) {
        super((Container)container);
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 194;
    }

    private int getEnergyBarScaled(int pixels) {
        int i = this.tile.getEnergy().getEnergyStored();
        int j = this.tile.getEnergy().getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    private int getMaterialBarScaled(int pixels) {
        int i = MathHelper.func_76125_a((int)this.tile.getMaterialCount(), (int)0, (int)this.tile.getRecipe().getInputCount());
        int j = this.tile.getRecipe().getInputCount();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    private int getProgressBarScaled(int pixels) {
        int i = this.tile.getProgress();
        int j = this.tile.getRecipe().getPowerCost();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 50.0f;
        this.field_146296_j.field_77023_b = 50.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    private void drawFakeItemStack(ItemStack stack, int xOffset, int yOffset, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        this.drawItemStack(stack, this.field_147003_i + xOffset, this.field_147009_r + yOffset, null);
        GlStateManager.func_179121_F();
    }

    private void drawFakeItemStackTooltip(ItemStack stack, int xOffset, int yOffset, int mouseX, int mouseY) {
        if (mouseX > this.field_147003_i + xOffset - 1 && mouseX < this.field_147003_i + xOffset + 16 && mouseY > this.field_147009_r + yOffset - 1 && mouseY < this.field_147009_r + yOffset + 16 && !stack.func_190926_b()) {
            this.func_146285_a(stack, mouseX, mouseY);
        }
    }

    private ItemStack getStack(Object obj) {
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).func_77946_l();
        }
        if (obj instanceof List) {
            return (ItemStack)((List)obj).get(0);
        }
        return ItemStack.field_190927_a;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = Utils.localize((String)"container.ec.compressor");
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(Utils.localize((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1) {
            NetworkThingy.THINGY.sendToServer((IMessage)new EjectModeSwitchPacket(this.tile.func_174877_v().func_177986_g()));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 69, this.field_147009_r + 29, 11, 9, null){

            public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            }
        });
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (mouseX > left + 7 && mouseX < this.field_147003_i + 20 && mouseY > this.field_147009_r + 17 && mouseY < this.field_147009_r + 94) {
            this.func_146283_a(Collections.singletonList(Utils.format((Object)this.tile.getEnergy().getEnergyStored()) + " FE"), mouseX, mouseY);
        }
        if (mouseX > left + 60 && mouseX < this.field_147003_i + 85 && mouseY > this.field_147009_r + 74 && mouseY < this.field_147009_r + 83) {
            ArrayList<String> l = new ArrayList<String>();
            if (this.tile.getMaterialCount() < 1) {
                l.add(Utils.localize((String)"tooltip.ec.empty"));
            } else {
                if (!this.tile.getMaterialStack().func_190926_b()) {
                    l.add(this.tile.getMaterialStack().func_82833_r());
                }
                l.add(Utils.format((Object)this.tile.getMaterialCount()) + " / " + Utils.format((Object)(this.tile.getRecipe() != null ? this.tile.getRecipe().getInputCount() : 0)));
            }
            this.func_146283_a(l, mouseX, mouseY);
        }
        if (mouseX > this.field_147003_i + 68 && mouseX < this.field_147003_i + 79 && mouseY > this.field_147009_r + 28 && mouseY < this.field_147009_r + 39) {
            if (this.tile.isEjecting()) {
                this.func_146279_a(Utils.localize((String)"tooltip.ec.ejecting"), mouseX, mouseY);
            } else {
                this.func_146279_a(Utils.localize((String)"tooltip.ec.eject"), mouseX, mouseY);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.getEnergyBarScaled(78);
        this.func_73729_b(x + 7, y + 95 - i1, 178, 78 - i1, 15, i1 + 1);
        if (this.tile != null && this.tile.getRecipe() != null) {
            int i2;
            if (this.tile.getMaterialCount() > 0 && this.tile.getRecipe().getInputCount() > 0) {
                i2 = this.getMaterialBarScaled(26);
                this.func_73729_b(x + 60, y + 74, 194, 19, i2 + 1, 10);
            }
            if (this.tile.getProgress() > 0 && this.tile.getRecipe().getPowerCost() > 0) {
                i2 = this.getProgressBarScaled(24);
                this.func_73729_b(x + 96, y + 47, 194, 0, i2 + 1, 16);
            }
        }
        if (mouseX > this.field_147003_i + 68 && mouseX < this.field_147003_i + 79 && mouseY > this.field_147009_r + 28 && mouseY < this.field_147009_r + 39) {
            this.func_73729_b(x + 68, y + 30, 194, 32, 11, 9);
        }
    }
}

