/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.util.Text;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.commons.lang3.StringUtils;

public class Toolbox {
    public static ITextComponent getTextPrefix() {
        return Text.of(TextFormatting.BLUE, TextFormatting.BOLD, new HoverEvent(HoverEvent.Action.SHOW_TEXT, Toolbox.getPluginInformation()), "[Sledgehammer]", " ");
    }

    public static ITextComponent getPluginInformation() {
        return Text.of(TextFormatting.BLUE, TextFormatting.BOLD, "Sledgehammer", Text.NEW_LINE, TextFormatting.DARK_GRAY, "    Version: ", TextFormatting.WHITE, "1.12.2-1.4.7", Text.NEW_LINE, TextFormatting.DARK_GRAY, "    Authors: ", TextFormatting.WHITE, "LX_Gaming", Text.NEW_LINE, TextFormatting.DARK_GRAY, "    Source: ", TextFormatting.BLUE, Toolbox.createURLEvent("https://github.com/LXGaming/Sledgehammer/"), "https://github.com/LXGaming/Sledgehammer/", Text.NEW_LINE, TextFormatting.DARK_GRAY, "    Website: ", TextFormatting.BLUE, Toolbox.createURLEvent("https://lxgaming.github.io/"), "https://lxgaming.github.io/");
    }

    public static ClickEvent createURLEvent(String url) {
        return new ClickEvent(ClickEvent.Action.OPEN_URL, url);
    }

    public static String convertColor(String string) {
        return string.replaceAll("(?i)&([0-9A-FK-OR])", "\u00a7$1");
    }

    public static String formatUnit(long unit, String singular, String plural) {
        if (unit == 1L) {
            return singular;
        }
        return plural;
    }

    public static boolean saveCrashReport(CrashReport crashReport) {
        Path crashPath = Paths.get("crash-reports", new String[0]).resolve("crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
        if (crashReport.func_147149_a(crashPath.toFile())) {
            Sledgehammer.getInstance().getLogger().info("This crash report has been saved to: {}", (Object)crashPath);
            return true;
        }
        Sledgehammer.getInstance().getLogger().error("We were unable to save this crash report to disk.");
        return false;
    }

    public static String getRootId(Entity entity) {
        ItemStack itemStack;
        if (entity instanceof EntityItem && !(itemStack = ((EntityItem)entity).func_92059_d()).func_190926_b()) {
            return Toolbox.getResourceLocation(itemStack.func_77973_b()).map(ResourceLocation::toString).orElse("Unknown");
        }
        return Toolbox.getResourceLocation(entity).map(ResourceLocation::toString).orElse("Unknown");
    }

    public static Optional<ResourceLocation> getResourceLocation(Object object) {
        if (object instanceof Block) {
            return Optional.of(Block.field_149771_c.func_177774_c((Object)((Block)object)));
        }
        if (object instanceof Entity) {
            return Optional.ofNullable(EntityList.func_191301_a((Entity)((Entity)object)));
        }
        if (object instanceof Item) {
            return Optional.ofNullable(Item.field_150901_e.func_177774_c((Object)((Item)object)));
        }
        return Optional.empty();
    }

    public static String filter(String string) {
        return StringUtils.replaceAll((String)string, (String)"[^\\x20-\\x7E\\x0A\\x0D]", (String)"");
    }

    public static boolean containsIgnoreCase(Collection<String> list, String targetString) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (String string : list) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)targetString)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Integer> parseInteger(String string) {
        try {
            return Optional.of(Integer.parseInt(string));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static boolean isClassStackFrame(String className, StackTraceElement[] stackTraceElements) {
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (!StringUtils.equals((CharSequence)stackTraceElement.getClassName(), (CharSequence)className)) continue;
            return true;
        }
        return false;
    }

    public static String getClassSimpleName(Class<?> clazz) {
        if (clazz.getEnclosingClass() != null) {
            return Toolbox.getClassSimpleName(clazz.getEnclosingClass()) + "." + clazz.getSimpleName();
        }
        return clazz.getSimpleName();
    }

    public static <T> T cast(Object object, Class<? extends T> type) {
        return type.cast(object);
    }

    public static <T> Optional<T> newInstance(Class<? extends T> type) {
        try {
            return Optional.of(type.newInstance());
        }
        catch (Throwable ex) {
            return Optional.empty();
        }
    }
}

