/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util;

import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.util.Text;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.StringUtils;

public class Broadcast {
    private final String message;
    private final String permission;
    private final ChatType type;

    private Broadcast(String message, String permission, ChatType type) {
        this.message = message;
        this.permission = permission;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void sendMessage() {
        MinecraftServer minecraftServer = SledgehammerPlatform.getInstance().getServer();
        if (minecraftServer != null) {
            this.sendMessage((ICommandSender)minecraftServer);
            minecraftServer.func_184103_al().func_181057_v().forEach(this::sendMessage);
        }
    }

    public void sendMessage(ICommandSender commandSender) {
        commandSender.func_145747_a(Text.of(Toolbox.getTextPrefix(), this.getMessage()));
    }

    public void sendMessage(EntityPlayer player) {
        if (StringUtils.isNotBlank((CharSequence)this.getPermission()) && !player.func_70003_b(4, this.getPermission()) || this.getType() == null) {
            return;
        }
        if (this.getType() == ChatType.GAME_INFO) {
            this.sendMessage(player, Text.of(this.getMessage()), this.getType());
        } else {
            this.sendMessage(player, Text.of(Toolbox.getTextPrefix(), this.getMessage()), this.getType());
        }
    }

    private void sendMessage(EntityPlayer player, ITextComponent message, ChatType chatType) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat(message, chatType));
            return;
        }
        Minecraft.func_71410_x().field_71456_v.func_191742_a(chatType, message);
    }

    public String getMessage() {
        return this.message;
    }

    public String getPermission() {
        return this.permission;
    }

    public ChatType getType() {
        return this.type;
    }

    public static final class Builder {
        private String message;
        private String permission;
        private ChatType type;

        public Broadcast build() {
            if (this.getMessage() == null) {
                this.message("");
            }
            return new Broadcast(this.getMessage(), this.getPermission(), this.getType());
        }

        private String getMessage() {
            return this.message;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        private String getPermission() {
            return this.permission;
        }

        public Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        private ChatType getType() {
            return this.type;
        }

        public Builder type(ChatType type) {
            this.type = type;
            return this;
        }
    }
}

