/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.core.world.chunk.storage;

import com.google.common.collect.Lists;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.mixin.ServerMixinCategory;
import io.github.lxgaming.sledgehammer.exception.ChunkSaveException;
import io.github.lxgaming.sledgehammer.interfaces.crash.IMixinCrashReport;
import io.github.lxgaming.sledgehammer.util.Broadcast;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.util.PrettyPrinter;

@Mixin(value={AnvilChunkLoader.class}, priority=1337)
public abstract class MixinAnvilChunkLoader {
    @Shadow
    @Final
    public File field_75825_d;

    @Shadow
    protected abstract void func_183013_b(ChunkPos var1, NBTTagCompound var2) throws IOException;

    @Redirect(method={"writeNextIO"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/AnvilChunkLoader;writeChunkData(Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/nbt/NBTTagCompound;)V"))
    private void onWriteChunkData(AnvilChunkLoader chunkLoader, ChunkPos pos, NBTTagCompound compound) throws IOException {
        boolean saveRequired;
        if (this.sledgehammer$writeChunk(pos, compound)) {
            return;
        }
        if (!compound.func_150297_b("Level", 10)) {
            Sledgehammer.getInstance().getLogger().error("Chunk ({}, {}) is missing its Level tag", (Object)pos.field_77276_a, (Object)pos.field_77275_b);
            return;
        }
        NBTTagCompound level = compound.func_74775_l("Level");
        if (Sledgehammer.getInstance().getConfig().map(Config::getServerMixinCategory).map(ServerMixinCategory::isChunkSavePurgeBlacklist).orElse(false).booleanValue()) {
            List blacklist = Sledgehammer.getInstance().getConfig().map(Config::getServerMixinCategory).map(ServerMixinCategory::getChunkSaveBlacklist).orElseGet(Lists::newArrayList);
            saveRequired = this.sledgehammer$removeEntityItems(level, item -> this.sledgehammer$checkItem((NBTTagCompound)item, blacklist::contains));
            if ((saveRequired |= this.sledgehammer$removeTileEntityItems(level, item -> this.sledgehammer$checkItem((NBTTagCompound)item, blacklist::contains))) && this.sledgehammer$writeChunk(pos, compound)) {
                Sledgehammer.getInstance().getLogger().info("Chunk ({}, {}) saved after removing Blacklisted Items from Entities and TileEntities", (Object)pos.field_77276_a, (Object)pos.field_77275_b);
                return;
            }
        }
        if (Sledgehammer.getInstance().getConfig().map(Config::getServerMixinCategory).map(ServerMixinCategory::isChunkSavePurgeAll).orElse(false).booleanValue()) {
            saveRequired = this.sledgehammer$removeEntities(level, entity -> true);
            if ((saveRequired |= this.sledgehammer$removeTileEntities(level, tileEntity -> true)) && this.sledgehammer$writeChunk(pos, compound)) {
                Sledgehammer.getInstance().getLogger().info("Chunk ({}, {}) saved after removing all Entities and TileEntities", (Object)pos.field_77276_a, (Object)pos.field_77275_b);
                return;
            }
        }
        if (SledgehammerPlatform.getInstance().getServer() == null || SledgehammerPlatform.getInstance().getServer().func_71278_l() || SledgehammerPlatform.getInstance().getServer().func_71241_aa()) {
            return;
        }
        if (Sledgehammer.getInstance().getConfig().map(Config::getServerMixinCategory).map(ServerMixinCategory::isChunkSaveShutdown).orElse(false).booleanValue()) {
            World world = this.sledgehammer$getWorld().orElse(null);
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)new ChunkSaveException(), (String)("Chunk (" + pos.field_77276_a + ", " + pos.field_77275_b + ") failed to save"));
            CrashReportCategory crashReportCategory = new CrashReportCategory(crashReport, "Affected level");
            crashReportCategory.func_189529_a("World", () -> {
                if (world != null) {
                    return String.format("%s", world.func_72912_H().func_76065_j());
                }
                return "Unknown";
            });
            crashReportCategory.func_189529_a("Players", () -> {
                if (world != null) {
                    return String.format("%d total; %s", world.field_73010_i.size(), world.field_73010_i);
                }
                return "Unknown";
            });
            crashReportCategory.func_189529_a("Location", () -> CrashReportCategory.func_180522_a((BlockPos)pos.func_180331_a(8, 0, 8)));
            Toolbox.cast(crashReport, IMixinCrashReport.class).addCategory(crashReportCategory);
            Toolbox.saveCrashReport(crashReport);
            new PrettyPrinter(50).add(crashReport.func_71501_a()).centre().hr().add("StackTrace:").add(crashReport.func_71505_b()).log(Sledgehammer.getInstance().getLogger(), Level.ERROR);
            SledgehammerPlatform.getInstance().getServer().func_184103_al().func_72371_a(true);
            SledgehammerPlatform.getInstance().getServer().func_71263_m();
            return;
        }
        if (Sledgehammer.getInstance().getConfig().map(Config::getServerMixinCategory).map(ServerMixinCategory::isChunkSaveAlert).orElse(false).booleanValue()) {
            Sledgehammer.getInstance().getConfig().map(Config::getGeneralCategory).ifPresent(generalCategory -> {
                String message = generalCategory.getMessageCategory().getChunkSave();
                if (StringUtils.isBlank((CharSequence)message)) {
                    return;
                }
                Broadcast.builder().message(Toolbox.convertColor(message.replace("[X]", String.valueOf(pos.field_77276_a)).replace("[Z]", String.valueOf(pos.field_77275_b)))).permission("sledgehammer.broadcast.chunksave").type(ChatType.CHAT).build().sendMessage();
            });
        }
    }

    private boolean sledgehammer$writeChunk(ChunkPos pos, NBTTagCompound compound) throws IOException {
        try {
            this.func_183013_b(pos, compound);
            return true;
        }
        catch (ChunkSaveException ex) {
            return false;
        }
    }

    private boolean sledgehammer$removeEntities(NBTTagCompound level, Predicate<NBTTagCompound> predicate) {
        AtomicInteger removed = new AtomicInteger(0);
        this.sledgehammer$forEachEntity(level, entity -> {
            if (predicate.test((NBTTagCompound)entity)) {
                removed.getAndIncrement();
                return true;
            }
            return false;
        });
        if (removed.get() > 0) {
            Sledgehammer.getInstance().getLogger().info("Removed {} {}", (Object)removed.get(), (Object)Toolbox.formatUnit(removed.get(), "Entity", "Entities"));
            return true;
        }
        return false;
    }

    private boolean sledgehammer$removeTileEntities(NBTTagCompound level, Predicate<NBTTagCompound> predicate) {
        AtomicInteger removed = new AtomicInteger(0);
        this.sledgehammer$forEachTileEntity(level, tileEntity -> {
            if (predicate.test((NBTTagCompound)tileEntity)) {
                removed.getAndIncrement();
                return true;
            }
            return false;
        });
        if (removed.get() > 0) {
            Sledgehammer.getInstance().getLogger().info("Removed {} {}", (Object)removed.get(), (Object)Toolbox.formatUnit(removed.get(), "TileEntity", "TileEntities"));
            return true;
        }
        return false;
    }

    private boolean sledgehammer$removeEntityItems(NBTTagCompound level, Predicate<NBTTagCompound> predicate) {
        AtomicInteger removedEntities = new AtomicInteger(0);
        AtomicInteger removedItems = new AtomicInteger(0);
        this.sledgehammer$forEachEntity(level, entity -> {
            if (entity.func_150297_b("Item", 10)) {
                NBTTagCompound tag;
                NBTTagCompound item = entity.func_74775_l("Item");
                if (predicate.test(item)) {
                    removedEntities.getAndIncrement();
                    return true;
                }
                if (item.func_150297_b("tag", 10) && (tag = item.func_74775_l("tag")).func_150297_b("BlockEntityTag", 10)) {
                    removedItems.getAndAdd(this.sledgehammer$removeItems(tag.func_74775_l("BlockEntityTag"), predicate));
                }
            }
            return false;
        });
        boolean saveRequired = false;
        if (removedItems.get() > 0) {
            Sledgehammer.getInstance().getLogger().info("Removed {} {} from Entities", (Object)removedItems.get(), (Object)Toolbox.formatUnit(removedItems.get(), "Item", "Items"));
            saveRequired = true;
        }
        if (removedEntities.get() > 0) {
            Sledgehammer.getInstance().getLogger().info("Removed {} {}", (Object)removedEntities.get(), (Object)Toolbox.formatUnit(removedEntities.get(), "Entity", "Entities"));
            saveRequired = true;
        }
        return saveRequired;
    }

    private boolean sledgehammer$removeTileEntityItems(NBTTagCompound level, Predicate<NBTTagCompound> predicate) {
        AtomicInteger removed = new AtomicInteger(0);
        this.sledgehammer$forEachTileEntity(level, tileEntity -> {
            removed.getAndAdd(this.sledgehammer$removeItems((NBTTagCompound)tileEntity, predicate));
            return false;
        });
        if (removed.get() > 0) {
            Sledgehammer.getInstance().getLogger().info("Removed {} {} from TileEntities", (Object)removed.get(), (Object)Toolbox.formatUnit(removed.get(), "Item", "Items"));
            return true;
        }
        return false;
    }

    private int sledgehammer$removeItems(NBTTagCompound compound, Predicate<NBTTagCompound> predicate) {
        int removed = 0;
        if (compound.func_150297_b("Items", 9)) {
            NBTTagList items = compound.func_150295_c("Items", 10);
            for (int index = 0; index < items.func_74745_c(); ++index) {
                NBTTagCompound tag;
                NBTTagCompound item = items.func_150305_b(index);
                if (predicate.test(item)) {
                    items.func_74744_a(index);
                    --index;
                    ++removed;
                    continue;
                }
                if (!item.func_150297_b("tag", 10) || !(tag = item.func_74775_l("tag")).func_150297_b("BlockEntityTag", 10)) continue;
                removed += this.sledgehammer$removeItems(tag.func_74775_l("BlockEntityTag"), predicate);
            }
        }
        return removed;
    }

    private boolean sledgehammer$checkItem(NBTTagCompound item, Predicate<String> predicate) {
        return item.func_150297_b("id", 8) && predicate.test(item.func_74779_i("id"));
    }

    private void sledgehammer$forEachEntity(NBTTagCompound level, Function<NBTTagCompound, Boolean> function) {
        if (level.func_150297_b("Entities", 9)) {
            NBTTagList entities = level.func_150295_c("Entities", 10);
            for (int index = 0; index < entities.func_74745_c(); ++index) {
                if (!function.apply(entities.func_150305_b(index)).booleanValue()) continue;
                entities.func_74744_a(index);
                --index;
            }
        }
    }

    private void sledgehammer$forEachTileEntity(NBTTagCompound level, Function<NBTTagCompound, Boolean> function) {
        if (level.func_150297_b("TileEntities", 9)) {
            NBTTagList tileEntities = level.func_150295_c("TileEntities", 10);
            for (int index = 0; index < tileEntities.func_74745_c(); ++index) {
                if (!function.apply(tileEntities.func_150305_b(index)).booleanValue()) continue;
                tileEntities.func_74744_a(index);
                --index;
            }
        }
    }

    private Optional<World> sledgehammer$getWorld() {
        for (WorldServer world : SledgehammerPlatform.getInstance().getServer().field_71305_c) {
            if (!world.func_72860_G().func_75765_b().equals(this.field_75825_d)) continue;
            return Optional.of(world);
        }
        return Optional.empty();
    }
}

