/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.launch;

import io.github.lxgaming.sledgehammer.launch.SledgehammerTweaker;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.ForgeVersion;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.common.SpongeImpl;

public class SledgehammerLaunch {
    private static final String FORGE_CLASS = "net.minecraftforge.fml.relauncher.CoreModManager";
    private static final String FORGE_INITIALIZED = "forge.initialized";
    private static final String SLEDGEHAMMER_INITIALIZED = "sledgehammer.initialized";
    private static final String SPONGE_CLASS = "org.spongepowered.common.launch.SpongeLaunch";
    private static final String SPONGE_INITIALIZED = "sponge.initialized";

    private SledgehammerLaunch() {
    }

    public static void configureClassLoader(LaunchClassLoader classLoader) {
        classLoader.addClassLoaderExclusion("io.github.lxgaming.sledgehammer.launch.");
    }

    public static void configureEnvironment() {
        if (!SledgehammerLaunch.isForgeRegistered() && SledgehammerLaunch.isClassPresent(FORGE_CLASS)) {
            SledgehammerLaunch.registerForge();
        }
        if (!SledgehammerLaunch.isMixinRegistered()) {
            MixinBootstrap.init();
        }
        if (!SledgehammerLaunch.isSledgehammerRegistered()) {
            SledgehammerLaunch.registerSledgehammer();
            if (SledgehammerLaunch.getTweakers().stream().anyMatch(SledgehammerTweaker.class::isInstance)) {
                Mixins.addConfiguration("mixins.sledgehammer.preinit.json");
            }
        }
        if (!SledgehammerLaunch.isSpongeRegistered() && SledgehammerLaunch.isClassPresent(SPONGE_CLASS)) {
            SledgehammerLaunch.registerSponge();
        }
    }

    public static boolean isClassPresent(String name) {
        try {
            return Class.forName(name, false, (ClassLoader)Launch.classLoader) != null;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static List<ITweaker> getTweakers() {
        return (List)GlobalProperties.get("Tweaks");
    }

    public static boolean isDeobfuscatedEnvironment() {
        return GlobalProperties.get("fml.deobfuscatedEnvironment", false);
    }

    public static boolean isForgeRegistered() {
        return GlobalProperties.get(FORGE_INITIALIZED) != null;
    }

    private static void registerForge() {
        GlobalProperties.put(FORGE_INITIALIZED, ForgeVersion.getVersion());
    }

    public static boolean isMixinRegistered() {
        return GlobalProperties.get("mixin.initialised") != null;
    }

    public static boolean isSledgehammerRegistered() {
        return GlobalProperties.get(SLEDGEHAMMER_INITIALIZED) != null;
    }

    private static void registerSledgehammer() {
        GlobalProperties.put(SLEDGEHAMMER_INITIALIZED, "1.12.2-1.4.7");
    }

    public static boolean isSpongeRegistered() {
        return GlobalProperties.get(SPONGE_INITIALIZED) != null;
    }

    private static void registerSponge() {
        GlobalProperties.put(SPONGE_INITIALIZED, SpongeImpl.MINECRAFT_VERSION.getName());
    }
}

