/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.manager.CommandManager;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCommand
implements ICommand {
    private final List<String> aliases = Lists.newArrayList();
    private final Set<AbstractCommand> children = Sets.newLinkedHashSet();
    private String description;
    private String permission;
    private String usage;

    public abstract void execute(ICommandSender var1, List<String> var2);

    public final void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        CommandManager.process(this, sender, args);
    }

    public final boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return this.checkPermission(sender);
    }

    public final boolean checkPermission(ICommandSender sender) {
        return StringUtils.isBlank((CharSequence)this.getPermission()) || sender.func_70003_b(4, this.getPermission());
    }

    public final List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Lists.newArrayList();
    }

    public final boolean func_82358_a(String[] args, int index) {
        return false;
    }

    protected final void addAlias(String alias) {
        CommandManager.registerAlias(this, alias);
    }

    protected final void addChild(Class<? extends AbstractCommand> commandClass) {
        CommandManager.registerCommand(this, commandClass);
    }

    public final String func_71517_b() {
        return this.func_71514_a().stream().filter(StringUtils::isNotBlank).findFirst().orElseThrow(IllegalStateException::new);
    }

    public final List<String> func_71514_a() {
        return this.aliases;
    }

    public final Set<AbstractCommand> getChildren() {
        return this.children;
    }

    public final String getDescription() {
        return this.description;
    }

    protected final void setDescription(String description) {
        this.description = description;
    }

    public final String getPermission() {
        return this.permission;
    }

    protected final void setPermission(String permission) {
        this.permission = permission;
    }

    public final String func_71518_a(ICommandSender sender) {
        return this.getUsage();
    }

    public final String getUsage() {
        return this.usage;
    }

    protected final void setUsage(String usage) {
        this.usage = usage;
    }

    public int compareTo(ICommand o) {
        return Objects.compare(this.func_71517_b(), o.func_71517_b(), String::compareTo);
    }
}

