/*
 * Decompiled with CFR 0.152.
 */
package com.polipo.fishing;

import com.polipo.fishing.BlockDynamicNetWet;
import com.polipo.fishing.BlockNetDry;
import com.polipo.fishing.FishingNet;
import com.polipo.fishing.TileEntityNet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class BlockStaticNetWet
extends BlockStaticLiquid
implements ITileEntityProvider {
    protected BlockStaticNetWet() {
        super(Material.field_151586_h);
        this.setRegistryName(new ResourceLocation("giacomos_fishing_net", "netWetStatic"));
        this.func_149663_c("netWetStatic");
        this.func_149675_a(false);
        this.func_149711_c(0.12f);
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70110_aj();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.LIQUID;
    }

    public int firstDelay(World worldIn) {
        return this.func_149738_a(worldIn);
    }

    public int func_149738_a(World worldIn) {
        return (int)(9600.0f * (0.8f + worldIn.field_73012_v.nextFloat() * 0.4f));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityNet) {
            TileEntityNet tileEntityNet = (TileEntityNet)tileEntity;
            tileEntityNet.update();
            this.scheduleNextUpdate(worldIn, pos, state, tileEntityNet);
        }
    }

    public void scheduleNextUpdate(World worldIn, BlockPos pos, IBlockState state, TileEntityNet tileEntityNet) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_184145_b(pos, state.func_177230_c())) {
                StructureBoundingBox stru = new StructureBoundingBox(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
                List list = worldIn.func_175712_a(stru, true);
                long currentTime = worldIn.func_82737_E();
                for (NextTickListEntry n : list) {
                    if (n.field_180282_a.equals((Object)pos)) continue;
                    int delay = (int)(n.field_77180_e - currentTime);
                    if (delay < 1) {
                        delay = 1;
                    }
                    worldIn.func_175654_a(n.field_180282_a, n.func_151351_a(), delay, n.field_82754_f);
                }
            }
            long elapsed = worldIn.func_82737_E() - tileEntityNet.lastUpdate;
            float rateFactor = 1.0f - 0.1666f * (float)tileEntityNet.speedBonus;
            int delay = (int)((float)this.func_149738_a(worldIn) * rateFactor - (float)elapsed);
            if (delay < 1) {
                delay = 1;
            }
            worldIn.func_175684_a(pos, state.func_177230_c(), delay);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNet(worldIn.func_82737_E());
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176365_e(worldIn, pos, state)) {
            worldIn.func_175684_a(pos, (Block)this, this.firstDelay(worldIn));
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityNet && !world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                TileEntityNet tileEntityNet = (TileEntityNet)tileEntity;
                tileEntityNet.dropItems(world, pos, player);
            }
            world.func_175713_t(pos);
            return world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    private void updateLiquid(World worldIn, BlockPos pos, IBlockState state) {
        BlockDynamicLiquid blockdynamicliquid = (BlockDynamicLiquid)FishingNet.netWetDynamic;
        worldIn.func_180501_a(pos, blockdynamicliquid.func_176223_P().func_177226_a((IProperty)field_176367_b, state.func_177229_b((IProperty)field_176367_b)), 2);
        worldIn.func_175684_a(pos, (Block)blockdynamicliquid, this.func_149738_a(worldIn));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        if (!this.func_176365_e(worldIn, pos, state)) {
            this.updateLiquid(worldIn, pos, state);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState newState = worldIn.func_180495_p(pos);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityNet) {
            if (!(newState.func_177230_c() instanceof BlockDynamicNetWet || newState.func_177230_c() instanceof BlockStaticNetWet || newState.func_177230_c() instanceof BlockNetDry)) {
                if (newState.func_177230_c() instanceof BlockLiquid && newState.func_185904_a() == Material.field_151586_h) {
                    IBlockState replaceState = FishingNet.netWetDynamic.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, newState.func_177229_b((IProperty)BlockLiquid.field_176367_b));
                    worldIn.func_175656_a(pos, replaceState);
                } else {
                    ((TileEntityNet)tileEntity).dropItems(worldIn, pos);
                    super.func_180663_b(worldIn, pos, state);
                }
            }
        } else {
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)FishingNet.itemNet);
    }
}

