/*
 * Decompiled with CFR 0.152.
 */
package ninjabrain.gendustryjei.wrappers;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import net.bdew.gendustry.config.Tuning;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import ninjabrain.gendustryjei.util.GeneticHelper;
import ninjabrain.gendustryjei.wrappers.WrapperGenetic;

public class WrapperMutatron
extends WrapperGenetic {
    ISpeciesRoot root;
    IMutation mutation;
    ItemStack parent0Stack;
    ItemStack parent1Stack;
    ItemStack resultStack;
    ItemStack labware;
    FluidStack inputFluid;
    private static boolean initialized = false;
    private static int fluidAmount;

    public WrapperMutatron(IMutation mutation) {
        this.root = mutation.getRoot();
        this.mutation = mutation;
        this.parent0Stack = GeneticHelper.getItemStackFromSpecies(this.root, mutation.getAllele0(), this.getSpeciesTypeForSlot(0, this.root));
        this.parent1Stack = GeneticHelper.getItemStackFromSpecies(this.root, mutation.getAllele1(), this.getSpeciesTypeForSlot(1, this.root));
        this.resultStack = GeneticHelper.getItemStackFromTemplate(this.root, mutation.getTemplate(), this.getSpeciesTypeForSlot(2, this.root));
        this.labware = WrapperMutatron.createLabwareStack();
        if (!initialized) {
            fluidAmount = Tuning.getSection((String)"Machines").getSection("Mutatron").getInt("MutagenPerItem");
            initialized = true;
        }
        this.inputFluid = new FluidStack(FluidRegistry.getFluid((String)"mutagen"), fluidAmount);
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.add(GeneticHelper.getAllItemsFromSpecies(this.root, this.mutation.getAllele0()));
        inputs.add(GeneticHelper.getAllItemsFromSpecies(this.root, this.mutation.getAllele1()));
        inputs.add(Collections.singletonList(this.labware));
        ingredients.setInputLists(ItemStack.class, inputs);
        List<List<ItemStack>> outputs = Collections.singletonList(GeneticHelper.getAllItemsFromTemplate(this.root, this.mutation.getTemplate()));
        ingredients.setOutputLists(ItemStack.class, outputs);
        ingredients.setInput(FluidStack.class, (Object)this.inputFluid);
    }

    protected ISpeciesType getSpeciesTypeForSlot(int slot, ISpeciesRoot root) {
        if (root instanceof IBeeRoot) {
            switch (slot) {
                case 0: {
                    return EnumBeeType.DRONE;
                }
                case 1: {
                    return EnumBeeType.PRINCESS;
                }
            }
            return EnumBeeType.QUEEN;
        }
        if (root instanceof ITreeRoot) {
            switch (slot) {
                case 0: {
                    return EnumGermlingType.POLLEN;
                }
                case 1: {
                    return EnumGermlingType.SAPLING;
                }
            }
            return EnumGermlingType.SAPLING;
        }
        return root.getIconType();
    }

    public ItemStack getParent0Stack() {
        return this.parent0Stack;
    }

    public ItemStack getParent1Stack() {
        return this.parent1Stack;
    }

    public ItemStack getResultStack() {
        return this.resultStack;
    }

    public ItemStack getLabware() {
        return this.labware;
    }
}

