/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.multiblock.block;

import com.valkyrieofnight.vlib.core.util.player.ChatUtil;
import com.valkyrieofnight.vlib.multiblock_legacy.api.tile.IMBTileCont;
import com.valkyrieofnight.vliblegacy.ValkyrieLib;
import com.valkyrieofnight.vliblegacy.lib.block.adv.color.VLBlockDecColor;
import java.util.List;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class VLBlockController
extends VLBlockDecColor
implements ITileEntityProvider {
    protected Class<? extends TileEntity> tc;
    public static EnumRarity[] RAREITIES = new EnumRarity[]{EnumRarity.COMMON, EnumRarity.UNCOMMON, EnumRarity.RARE, EnumRarity.EPIC, ValkyrieLib.LEGENDARY, ValkyrieLib.MYTHIC};

    public VLBlockController(String blockName, Material mat, int color, Class<? extends TileEntity> tc) {
        super(blockName, mat, color);
        if (IMBTileCont.class.isAssignableFrom(tc)) {
            // empty if block
        }
        this.tc = tc;
        this.color = color;
        this.setHarvestLevel("pickaxe", 1);
        this.registerTile();
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!this.canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)player) && !player.func_184812_l_()) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public EnumRarity getRarity() {
        if (this.getTier() < 0) {
            return EnumRarity.COMMON;
        }
        if (this.getTier() >= RAREITIES.length) {
            return ValkyrieLib.MYTHIC;
        }
        return RAREITIES[this.getTier()];
    }

    public abstract int getTier();

    public void registerTile() {
        GameRegistry.registerTileEntity(this.tc, (String)(this.getRegistryName() + ".tile"));
    }

    public void func_180649_a(World w, BlockPos pos, EntityPlayer player) {
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof IMBTileCont) {
            IMBTileCont cnt = (IMBTileCont)te;
            if (cnt.getOwnerUUID() == null) {
                cnt.setOwner(playerIn.func_146103_bH());
            }
            List<ITextComponent> mess = ((IMBTileCont)te).getFinalInfo();
            ChatUtil.noSpamServer(playerIn, mess);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(World w, BlockPos pos, IBlockState state) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof IMBTileCont) {
            IMBTileCont st = (IMBTileCont)te;
            st.deformMultiblock();
        }
        super.func_180663_b(w, pos, state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        try {
            return this.tc.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

