/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public abstract class VLItemHandlerLimited
extends ItemStackHandler {
    private boolean changedSinceLastCheck = false;
    private boolean extract = true;
    private boolean insert = true;

    public VLItemHandlerLimited() {
        super(1);
    }

    public VLItemHandlerLimited(int size) {
        super(size);
    }

    public VLItemHandlerLimited(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public abstract boolean isValidInput(ItemStack var1);

    public int getFreeSlots() {
        int fs = 0;
        for (ItemStack itemStack : this.stacks) {
            if (itemStack != ItemStack.field_190927_a) continue;
            ++fs;
        }
        return fs;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.changedSinceLastCheck = true;
        super.setStackInSlot(slot, stack);
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.insert) {
            return stack;
        }
        this.changedSinceLastCheck = true;
        if (this.isValidInput(stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.extract) {
            return ItemStack.field_190927_a;
        }
        this.changedSinceLastCheck = true;
        return super.extractItem(slot, amount, simulate);
    }

    public boolean hasChanged() {
        if (this.changedSinceLastCheck) {
            this.changedSinceLastCheck = false;
            return true;
        }
        return false;
    }

    protected void onContentsChanged(int slot) {
        this.changedSinceLastCheck = true;
    }

    public void setIO(boolean insert, boolean extract) {
        this.extract = extract;
        this.insert = insert;
    }

    public ItemStack iInsert(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack iExtract(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }
}

