/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container;

import com.valkyrieofnight.vliblegacy.lib.client.gui.VLGui;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiDraw;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiDrawTooltip;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiInput;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiInputAction;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiUpdate;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.ToolTipList;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElement;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class VLEleContBase
extends VLElement
implements IGuiInput,
IGuiInputAction,
IGuiDraw,
IGuiDrawTooltip,
IGuiUpdate,
VLGui {
    protected LinkedList<VLElement> elements = new LinkedList();
    protected ToolTipList tooltips;

    public VLEleContBase(String elementID) {
        super(elementID);
    }

    public void addElement(VLElement ele) {
        if (ele == null) {
            return;
        }
        ele.setGui(this);
        if (this.onElementAdded(ele)) {
            this.elements.addLast(ele);
        }
    }

    public int getTotalElements() {
        return this.elements.size();
    }

    @Override
    public final void init() {
        this.preInit();
        this.addElements();
        this.postInit();
    }

    protected abstract boolean onElementAdded(VLElement var1);

    protected abstract void preInit();

    protected abstract void postInit();

    public abstract void addElements();

    @Override
    public Gui getGui() {
        return this.gui.getGui();
    }

    @Override
    public int getGuiLeft() {
        return this.gui.getGuiLeft() + this.xPosOffset;
    }

    @Override
    public int getGuiTop() {
        return this.gui.getGuiTop() + this.yPosOffset;
    }

    @Override
    public int getGuiSizeX() {
        return this.xSize;
    }

    @Override
    public int getGuiSizeY() {
        return this.ySize;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.gui.getFontRenderer();
    }

    @Override
    public void drawHoverText(List<String> list, int x, int y) {
        this.gui.drawHoverText(list, x, y);
    }

    @Override
    public boolean isInGUI(int x, int y) {
        return this.gui.isInBoxAndGUI(x, y, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize());
    }

    @Override
    public void update() {
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiUpdate)) continue;
            ((IGuiUpdate)((Object)ele)).update();
        }
    }

    @Override
    public void addToolTip(String localizedToolTip) {
        this.tooltips.addToolTip(localizedToolTip);
    }

    @Override
    public void setToolTipList(List<String> toolTips) {
        this.tooltips.setToolTipList(toolTips);
    }

    @Override
    public void drawToolTip(int mx, int my) {
        boolean isInBox = false;
        if (this.isInBox(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize())) {
            isInBox = true;
        }
        for (VLElement ele : this.elements) {
            if (!ele.isEnabledOutsideOfGui() && !isInBox || !(ele instanceof IGuiDrawTooltip)) continue;
            ((IGuiDrawTooltip)((Object)ele)).drawToolTip(mx, my);
        }
    }

    @Override
    public void drawBackgroundLayer(int mx, int my, float partialTicks) {
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiDraw) || !((IGuiDraw)((Object)ele)).isBackgroundVisible()) continue;
            ((IGuiDraw)((Object)ele)).drawBackgroundLayer(mx, my, partialTicks);
        }
    }

    @Override
    public void drawForegroundLayer(int mx, int my, float partialTicks) {
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiDraw) || !((IGuiDraw)((Object)ele)).isForegroundVisible()) continue;
            ((IGuiDraw)((Object)ele)).drawForegroundLayer(mx, my, partialTicks);
        }
    }

    @Override
    public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
    }

    @Override
    public void mouseScrolled(VLElement ele, int mx, int my, int scroll) {
    }

    @Override
    public void keyTyped(VLElement ele, char character, int keyCode) {
    }

    @Override
    public boolean onMouseClicked(int mx, int my, int mouseButton) {
        boolean any = false;
        boolean isInBox = false;
        if (this.isInBox(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize())) {
            isInBox = true;
        }
        for (VLElement ele : this.elements) {
            if (!ele.isEnabledOutsideOfGui() && !isInBox || !(ele instanceof IGuiInput) || !((IGuiInput)((Object)ele)).onMouseClicked(mx, my, mouseButton)) continue;
            this.mouseClicked(ele, mx, my, mouseButton);
            any = true;
        }
        return any;
    }

    @Override
    public boolean onMouseScrolled(int mx, int my, int scroll) {
        boolean any = false;
        boolean isInBox = false;
        if (this.isInBox(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize())) {
            isInBox = true;
        }
        for (VLElement ele : this.elements) {
            if (!ele.isEnabledOutsideOfGui() && !isInBox || !(ele instanceof IGuiInput) || !((IGuiInput)((Object)ele)).onMouseScrolled(mx, my, scroll)) continue;
            this.mouseScrolled(ele, mx, my, scroll);
            any = true;
        }
        return any;
    }

    @Override
    public boolean onKeyTyped(char c, int keyCode) {
        boolean any = false;
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiInput) || !((IGuiInput)((Object)ele)).onKeyTyped(c, keyCode)) continue;
            this.keyTyped(ele, c, keyCode);
            any = true;
        }
        return any;
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound nt = nbt.func_74775_l(this.elementID);
        for (VLElement vlElement : this.elements) {
            vlElement.readFromNBT(nt);
        }
        this.readOtherFromNBT(nbt);
    }

    public void readOtherFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound nt = new NBTTagCompound();
        for (VLElement vlElement : this.elements) {
            vlElement.writeToNBT(nt);
        }
        this.writeOtherToNBT(nbt);
        if (nt.func_186856_d() > 0) {
            nbt.func_74782_a(this.elementID, (NBTBase)nt);
        }
        return nbt;
    }

    public NBTTagCompound writeOtherToNBT(NBTTagCompound nbt) {
        return nbt;
    }
}

