/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.enderbook;

import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.item.enderbook.ItemEnderBook;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilExperience;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketWarpButton
implements IMessage,
IMessageHandler<PacketWarpButton, IMessage> {
    public int slot;

    public PacketWarpButton() {
    }

    public PacketWarpButton(int s) {
        this.slot = s;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
    }

    public IMessage onMessage(final PacketWarpButton message, final MessageContext ctx) {
        MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
        s.func_152344_a(new Runnable(){

            @Override
            public void run() {
                PacketWarpButton.this.handle(message, ctx);
            }
        });
        return null;
    }

    protected void handle(PacketWarpButton message, MessageContext ctx) {
        EntityPlayerMP player = ((NetHandlerPlayServer)ctx.netHandler).field_147369_b;
        ItemStack bookStack = ItemEnderBook.getPlayersBook((EntityPlayer)player);
        BlockPos oldPos = player.func_180425_c();
        int cost = ItemEnderBook.getExpCostPerTeleport((EntityPlayer)player, bookStack, message.slot);
        boolean success = false;
        if (player.func_184812_l_()) {
            success = ItemEnderBook.teleport((EntityPlayer)player, message.slot);
        } else if (cost > 0 && UtilExperience.getExpTotal((EntityPlayer)player) < (double)cost) {
            UtilChat.addChatMessage((EntityPlayer)player, "gui.chatexp");
        } else if (ItemEnderBook.teleport((EntityPlayer)player, message.slot)) {
            UtilExperience.drainExp((EntityPlayer)player, cost);
            success = true;
        }
        if (success) {
            if (message.slot == 7777) {
                ItemEnderBook.clearBackTimer(bookStack);
            } else {
                ItemEnderBook.startBackTimer(bookStack, new BlockPosDim(7777, oldPos, player.field_71093_bK, ""));
            }
        }
    }
}

