/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.conveyor;

import com.lothrazar.cyclicmagic.block.conveyor.BlockConveyor;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConveyorAngle
extends BlockConveyor
implements IHasRecipe {
    public static final PropertyBool FLIPPED = PropertyBool.func_177716_a((String)"flipped");

    public BlockConveyorAngle(BlockConveyor.SpeedType type) {
        super(type);
        this.keepEntityGrounded = false;
        this.setAngled(this);
    }

    @Override
    public boolean isAngle() {
        return true;
    }

    public void setDrop(BlockConveyor drop) {
        this.flatType = drop;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING, FLIPPED});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)FLIPPED) != false ? 10 : 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        int facingbits = facing.func_176736_b();
        return facingbits + meta;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean flipped = false;
        if (meta >= 10) {
            flipped = true;
            meta -= 10;
        }
        return super.func_176203_a(meta).func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(flipped));
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Block.field_185505_j;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        double heightInc = 0.0125;
        double sideInc = 0.0125;
        double height = 0.0;
        switch (this.getFacingFromState(state)) {
            case DOWN: 
            case UP: {
                break;
            }
            case WEST: {
                double edge;
                for (edge = 1.0; edge > 0.0; edge -= 0.0125) {
                    BlockConveyorAngle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, height, 0.0, edge, height + 0.0125, 1.0));
                    height += 0.0125;
                }
                break;
            }
            case EAST: {
                double edge;
                for (edge = 0.0125; edge < 1.0; edge += 0.0125) {
                    BlockConveyorAngle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(1.0, height, 0.0, edge, height + 0.0125, 1.0));
                    height += 0.0125;
                }
                break;
            }
            case NORTH: {
                double edge;
                while (edge > 0.0) {
                    BlockConveyorAngle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, height, 0.0, 1.0, height + 0.0125, edge));
                    height += 0.0125;
                    edge -= 0.0125;
                }
                break;
            }
            case SOUTH: {
                double edge;
                for (edge = 0.0125; edge < 1.0; edge += 0.0125) {
                    BlockConveyorAngle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, height, 1.0, 1.0, height + 0.0125, edge));
                    height += 0.0125;
                }
                break;
            }
        }
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (sneakPlayerAvoid && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af()) {
            return;
        }
        boolean isGoingDown = (Boolean)state.func_177229_b((IProperty)FLIPPED);
        EnumFacing face = this.getFacingFromState(state);
        if (isGoingDown) {
            face = face.func_176734_d();
        }
        if (!(entity instanceof EntityLivingBase)) {
            entity.field_70122_E = false;
            float yaw = 0.0f;
            switch (face) {
                case DOWN: {
                    break;
                }
                case EAST: {
                    yaw = 270.0f;
                    break;
                }
                case NORTH: {
                    yaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 0.0f;
                    break;
                }
                case UP: {
                    break;
                }
                case WEST: {
                    yaw = 90.0f;
                    break;
                }
            }
            int degree = isGoingDown ? -45 : 45;
            float pwr = isGoingDown ? this.power : this.power * 1.5f;
            UtilEntity.setVelocity(entity, degree, yaw, pwr);
        } else {
            this.tickMovement(pos, entity, face);
        }
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 2), "cc", "uu", Character.valueOf('c'), this.flatType, Character.valueOf('u'), new ItemStack(Blocks.field_150348_b));
    }
}

