/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.init.NCItems;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.fluids.FluidRegistry;

public class MelterRecipes
extends ProcessorRecipeHandler {
    private static final List<String> MELTING_BLACKLIST = Arrays.asList("coal", "redstone", "glowstone", "prismarine", "obsidian", "silicon");

    public MelterRecipes() {
        super("melter", 1, 0, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addRecipe("dustSulfur", MelterRecipes.fluidStack("sulfur", 666), 1.0, 1.0);
        this.addRecipe("dustSodiumHydroxide", MelterRecipes.fluidStack("naoh", 666), 1.0, 1.0);
        this.addRecipe("dustPotassiumHydroxide", MelterRecipes.fluidStack("koh", 666), 1.0, 1.0);
        this.addRecipe("dustArsenic", MelterRecipes.fluidStack("arsenic", 666), 1.0, 1.0);
        this.addRecipe("gemBoronArsenide", MelterRecipes.fluidStack("bas", 666), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gemPrismarine", "dustPrismarine"}), MelterRecipes.fluidStack("prismarine", 144), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotSilicon", "itemSilicon"}), MelterRecipes.fluidStack("silicon", 144), 1.0, 1.0);
        this.addIngotMeltingRecipes("boron10");
        this.addIngotMeltingRecipes("boron11");
        this.addIngotMeltingRecipes("lithium6");
        this.addIngotMeltingRecipes("lithium7");
        this.addIngotMeltingRecipes("hardCarbon", "hard_carbon");
        this.addIngotMeltingRecipes("manganeseDioxide", "manganese_dioxide");
        this.addIngotMeltingRecipes("alugentum");
        this.addRecipe(NCItems.ground_cocoa_nibs, MelterRecipes.fluidStack("chocolate_liquor", 144), 0.25, 0.5);
        this.addRecipe(NCItems.cocoa_butter, MelterRecipes.fluidStack("cocoa_butter", 144), 0.25, 0.5);
        this.addRecipe(NCItems.unsweetened_chocolate, MelterRecipes.fluidStack("unsweetened_chocolate", 144), 0.25, 0.5);
        this.addRecipe(NCItems.dark_chocolate, MelterRecipes.fluidStack("dark_chocolate", 144), 0.25, 0.5);
        this.addRecipe(NCItems.milk_chocolate, MelterRecipes.fluidStack("milk_chocolate", 144), 0.25, 0.5);
        this.addRecipe(Items.field_151102_aT, MelterRecipes.fluidStack("sugar", 144), 0.5, 0.5);
        this.addRecipe(NCItems.gelatin, MelterRecipes.fluidStack("gelatin", 144), 0.5, 0.5);
        this.addRecipe(NCItems.marshmallow, MelterRecipes.fluidStack("marshmallow", 144), 0.5, 0.5);
        this.addRecipe("obsidian", MelterRecipes.fluidStack("obsidian", 288), 2.0, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotObsidian", "dustObsidian"}), MelterRecipes.fluidStack("obsidian", 72), 0.5, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nuggetObsidian", "tinyDustObsidian"}), MelterRecipes.fluidStack("obsidian", 8), 0.05555555555555555, 2.0);
        this.addRecipe("sand", MelterRecipes.fluidStack("glass", 1000), 1.5, 1.5);
        this.addRecipe("blockGlass", MelterRecipes.fluidStack("glass", 1000), 1.5, 1.5);
        this.addRecipe(Blocks.field_150435_aG, MelterRecipes.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe(Items.field_151119_aD, MelterRecipes.fluidStack("clay", 144), 0.5, 1.5);
        this.addRecipe(Blocks.field_150336_V, MelterRecipes.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe("ingotBrick", MelterRecipes.fluidStack("clay", 144), 0.5, 1.5);
        this.addRecipe(Blocks.field_150405_ch, MelterRecipes.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe("stone", MelterRecipes.fluidStack("stone", 72), 1.5, 1.5);
        this.addRecipe("cobblestone", MelterRecipes.fluidStack("stone", 72), 1.5, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dirt", "grass"}), MelterRecipes.fluidStack("dirt", 144), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dustRedstone", "ingotRedstone"}), MelterRecipes.fluidStack("redstone", 100), 0.25, 1.0);
        this.addRecipe("blockRedstone", MelterRecipes.fluidStack("redstone", 900), 2.0, 1.0);
        this.addRecipe("dustGlowstone", MelterRecipes.fluidStack("glowstone", 250), 0.25, 1.0);
        this.addRecipe("glowstone", MelterRecipes.fluidStack("glowstone", 1000), 2.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new Object[]{Items.field_151079_bi, "dustEnder"}), MelterRecipes.fluidStack("ender", 250), 0.5, 1.5);
        this.addRecipe("dustPyrotheum", MelterRecipes.fluidStack("pyrotheum", 250), 1.0, 1.0);
        this.addRecipe("dustCryotheum", MelterRecipes.fluidStack("cryotheum", 250), 1.0, 1.0);
        this.addRecipe("dustAerotheum", MelterRecipes.fluidStack("aerotheum", 250), 1.0, 1.0);
        this.addRecipe("dustPetrotheum", MelterRecipes.fluidStack("petrotheum", 250), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"coal", "dustCoal"}), MelterRecipes.fluidStack("coal", 100), 0.5, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotGraphite", "dustGraphite"}), MelterRecipes.fluidStack("coal", 100), 0.5, 1.0);
        this.addRecipe("blockCoal", MelterRecipes.fluidStack("coal", 900), 4.5, 1.0);
        this.addRecipe("blockGraphite", MelterRecipes.fluidStack("coal", 900), 4.5, 1.0);
        this.addIngotMeltingRecipes("electricalSteel", "electrical_steel");
        this.addIngotMeltingRecipes("energeticAlloy", "energetic_alloy");
        this.addIngotMeltingRecipes("vibrantAlloy", "vibrant_alloy");
        this.addIngotMeltingRecipes("redstoneAlloy", "redstone_alloy");
        this.addIngotMeltingRecipes("conductiveIron", "conductive_iron");
        this.addIngotMeltingRecipes("pulsatingIron", "pulsating_iron");
        this.addIngotMeltingRecipes("darkSteel", "dark_steel");
        this.addIngotMeltingRecipes("soularium", "soularium");
        this.addIngotMeltingRecipes("endSteel", "end_steel");
        this.addIngotMeltingRecipes("constructionAlloy", "construction_alloy");
        this.addIngotMeltingRecipes("crudeSteel", "crude_steel");
        this.addIngotMeltingRecipes("crystallineAlloy", "crystalline_alloy");
        this.addIngotMeltingRecipes("melodicAlloy", "melodic_alloy");
        this.addIngotMeltingRecipes("stellarAlloy", "stellar_alloy");
        this.addIngotMeltingRecipes("crystallinePinkSlime", "crystalline_pink_slime");
        this.addIngotMeltingRecipes("energeticSilver", "energetic_silver");
        this.addIngotMeltingRecipes("vividAlloy", "vivid_alloy");
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"itemSalt", "dustSalt"}), MelterRecipes.fluidStack("brine", 15), 0.25, 0.5);
        this.addIngotMeltingRecipes("dilithium");
        this.addIngotMeltingRecipes("manasteel");
        this.addIngotMeltingRecipes("terrasteel");
        this.addIngotMeltingRecipes("elementium");
        this.addIngotMeltingRecipes("refinedObsidian", "refinedobsidian");
        this.addIngotMeltingRecipes("refinedGlowstone", "refinedglowstone");
        this.addIngotMeltingRecipes("psi");
        this.addIngotMeltingRecipes("astralStarmetal");
        this.addIngotMeltingRecipes("baseEssence");
        this.addIngotMeltingRecipes("inferium");
        this.addIngotMeltingRecipes("prudentium");
        this.addIngotMeltingRecipes("intermedium");
        this.addIngotMeltingRecipes("superium");
        this.addIngotMeltingRecipes("supremium");
        this.addIsotopeMeltingRecipes("thorium", 230);
        this.addIngotMeltingRecipes("thorium232", "fuel_tbu");
        this.addIsotopeMeltingRecipes("uranium", 233, 235, 238);
        this.addIsotopeMeltingRecipes("neptunium", 236, 237);
        this.addIsotopeMeltingRecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeMeltingRecipes("americium", 241, 242, 243);
        this.addIsotopeMeltingRecipes("curium", 243, 245, 246, 247);
        this.addIsotopeMeltingRecipes("berkelium", 247, 248);
        this.addIsotopeMeltingRecipes("californium", 249, 250, 251, 252);
        for (String suffix : new String[]{"", "Oxide"}) {
            for (String prefix : new String[]{"fuel", "fuelRod"}) {
                this.addRecipe(prefix + "TBU" + suffix, MelterRecipes.fluidStack("fuel_tbu", 1296), 9.0);
            }
            for (String prefix : new String[]{"depletedFuel", "depletedFuelRod"}) {
                this.addRecipe(prefix + "TBU" + suffix, MelterRecipes.fluidStack("depleted_fuel_tbu", 1024), 7.111111111111111);
            }
        }
        this.addFissionFuelMeltingRecipes("uranium", "eu", 233, 235);
        this.addFissionFuelMeltingRecipes("neptunium", "en", 236);
        this.addFissionFuelMeltingRecipes("plutonium", "ep", 239, 241);
        this.addFissionFuelMeltingRecipes("americium", "ea", 242);
        this.addFissionFuelMeltingRecipes("curium", "ec", "m", 243, 245, 247);
        this.addFissionFuelMeltingRecipes("berkelium", "eb", 248);
        this.addFissionFuelMeltingRecipes("californium", "ec", "f", 249, 251);
        this.addRecipe(Blocks.field_150432_aD, MelterRecipes.fluidStack("water", 1000), 0.25, 0.5);
        this.addRecipe(Blocks.field_150403_cj, MelterRecipes.fluidStack("water", 1000), 0.5, 0.5);
        this.addOreMeltingRecipes();
        this.addIngotMeltingRecipes("thoriumOxide", "thorium");
        this.addIngotMeltingRecipes("uraniumOxide", "uranium");
        this.addRecipe("blockQuartz", MelterRecipes.fluidStack("quartz", 2664), 4.0, 1.0);
        this.addRecipe("blockLapis", MelterRecipes.fluidStack("lapis", 5994), 9.0, 1.0);
        this.addRecipe("blockDiamond", MelterRecipes.fluidStack("diamond", 5994), 9.0, 1.0);
        this.addRecipe("blockEmerald", MelterRecipes.fluidStack("emerald", 5994), 9.0, 1.0);
    }

    public void addIngotMeltingRecipes(String oreName, String fluidName) {
        oreName = StringHelper.capitalize(oreName);
        this.addRecipe("ore" + oreName, MelterRecipes.fluidStack(fluidName, 360), 1.25, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingot" + oreName, "dust" + oreName}), MelterRecipes.fluidStack(fluidName, 144), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nugget" + oreName, "tinyDust" + oreName}), MelterRecipes.fluidStack(fluidName, 16), 0.1111111111111111, 1.0);
        this.addRecipe("block" + oreName, MelterRecipes.fluidStack(fluidName, 1296), 9.0, 1.0);
    }

    public void addIngotMeltingRecipes(String name) {
        this.addIngotMeltingRecipes(name, name);
    }

    public void addGemMeltingRecipes(String name) {
        String oreName = StringHelper.capitalize(name);
        this.addRecipe("ore" + oreName, MelterRecipes.fluidStack(name, 1665), 1.25, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gem" + oreName, "dust" + oreName}), MelterRecipes.fluidStack(name, 666), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nugget" + oreName, "tinyDust" + oreName}), MelterRecipes.fluidStack(name, 74), 0.1111111111111111, 1.0);
    }

    public void addIsotopeMeltingRecipes(String element, int ... types) {
        for (int type : types) {
            this.addIngotMeltingRecipes(element + type, element + "_" + type);
        }
    }

    public void addFissionFuelMeltingRecipes(String element, String suffix, String suffixExtra, int ... types) {
        for (int type : types) {
            for (String oxide : new String[]{"", "Oxide"}) {
                for (String prefix : new String[]{"fuel", "fuelRod"}) {
                    this.addRecipe(prefix + "L" + suffix.toUpperCase() + suffixExtra + type + oxide, MelterRecipes.fluidStack("fuel_l" + suffix + suffixExtra + "_" + type, 1296), 9.0, 1.0);
                    this.addRecipe(prefix + "H" + suffix.toUpperCase() + suffixExtra + type + oxide, MelterRecipes.fluidStack("fuel_h" + suffix + suffixExtra + "_" + type, 1296), 9.0, 1.0);
                }
                for (String prefix : new String[]{"depletedFuel", "depletedFuelRod"}) {
                    this.addRecipe(prefix + "L" + suffix.toUpperCase() + suffixExtra + type + oxide, MelterRecipes.fluidStack("depleted_fuel_l" + suffix + suffixExtra + "_" + type, 1024), 7.111111111111111, 1.0);
                    this.addRecipe(prefix + "H" + suffix.toUpperCase() + suffixExtra + type + oxide, MelterRecipes.fluidStack("depleted_fuel_h" + suffix + suffixExtra + "_" + type, 1024), 7.111111111111111, 1.0);
                }
            }
        }
    }

    public void addFissionFuelMeltingRecipes(String element, String suffix, int ... types) {
        this.addFissionFuelMeltingRecipes(element, suffix, "", types);
    }

    public void addOreMeltingRecipes() {
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().keySet());
        for (String fluidName : fluidList) {
            if (MELTING_BLACKLIST.contains(fluidName)) continue;
            String materialName = StringHelper.capitalize(fluidName);
            String ingot = "ingot" + materialName;
            String gem = "gem" + materialName;
            String dust = "dust" + materialName;
            if (OreDictHelper.oreExists(ingot) && OreDictHelper.oreExists(dust)) {
                this.addIngotMeltingRecipes(fluidName);
                continue;
            }
            if (!OreDictHelper.oreExists(gem) || !OreDictHelper.oreExists(dust)) continue;
            this.addGemMeltingRecipes(fluidName);
        }
    }
}

