/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import ic2.api.reactor.IReactor;
import java.util.List;
import nc.ModCheck;
import nc.capability.radiation.IRadiation;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadBiomes;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.ArmorHelper;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RadiationHelper {
    public static IEntityRads getEntityRadiation(EntityLivingBase entity) {
        if (entity == null || !entity.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return null;
        }
        return (IEntityRads)entity.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
    }

    public static IRadiationSource getRadiationSource(ICapabilityProvider provider) {
        if (provider == null || !provider.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return null;
        }
        return (IRadiationSource)provider.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
    }

    public static IRadiationResistance getRadiationResistance(ICapabilityProvider provider) {
        if (provider == null || !provider.hasCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null)) {
            return null;
        }
        return (IRadiationResistance)provider.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
    }

    public static IItemHandler getTileInventory(ICapabilityProvider provider, EnumFacing side) {
        if (!(provider instanceof TileEntity) || !provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return null;
        }
        return (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public static void addToSourceBuffer(IRadiationSource source, double addedRadiation) {
        source.setRadiationBuffer(source.getRadiationBuffer() + addedRadiation);
    }

    public static void addToSourceRadiation(IRadiationSource source, double addedRadiation) {
        source.setRadiationLevel(source.getRadiationLevel() + addedRadiation);
    }

    public static void addFractionToChunkBuffer(IRadiationSource chunkSource, ITileRadiationEnvironment tile) {
        if (chunkSource == null) {
            return;
        }
        RadiationHelper.addToSourceBuffer(chunkSource, tile.getContributionFraction() * tile.getCurrentChunkBuffer());
        if (tile.getContributionFraction() < 0.0) {
            chunkSource.addScrubbingFraction(-tile.getContributionFraction());
        }
    }

    public static void transferRadiationFromStackToChunkBuffer(ItemStack stack, IRadiationSource chunkSource, double multiplier) {
        if (chunkSource == null) {
            return;
        }
        RadiationHelper.addToSourceBuffer(chunkSource, RadiationHelper.getRadiationFromStack(stack, multiplier));
    }

    public static double getRadiationFromStack(ItemStack stack, double multiplier) {
        if (stack.func_190926_b()) {
            return 0.0;
        }
        IRadiationSource stackSource = RadiationHelper.getRadiationSource((ICapabilityProvider)stack);
        if (stackSource == null) {
            return 0.0;
        }
        return stackSource.getRadiationLevel() * (double)stack.func_190916_E() * multiplier;
    }

    public static void transferRadiationFromProviderToChunkBuffer(ICapabilityProvider provider, EnumFacing side, IRadiationSource chunkSource) {
        IRadiationSource radiationSource;
        if (chunkSource == null) {
            return;
        }
        double rawRadiation = 0.0;
        if (ModCheck.ic2Loaded() && provider instanceof IReactor) {
            rawRadiation += ((IReactor)provider).getReactorEUEnergyOutput() * 1.0E-5;
        }
        IItemHandler inventory = RadiationHelper.getTileInventory(provider, side);
        if (NCConfig.radiation_hardcore_containers > 0.0 && inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                rawRadiation += RadiationHelper.getRadiationFromStack(stack, NCConfig.radiation_hardcore_containers);
            }
        }
        if ((radiationSource = RadiationHelper.getRadiationSource(provider)) != null) {
            rawRadiation += radiationSource.getRadiationLevel();
        }
        double resistance = 0.0;
        IRadiationResistance providerResistance = RadiationHelper.getRadiationResistance(provider);
        if (providerResistance != null) {
            resistance = providerResistance.getRadiationResistance();
        }
        double radiation = rawRadiation <= 0.0 ? 0.0 : NCMath.square(rawRadiation) / (rawRadiation + resistance);
        RadiationHelper.addToSourceBuffer(chunkSource, radiation);
    }

    public static void transferRadsFromInventoryToChunkBuffer(InventoryPlayer inventory, IRadiationSource chunkSource) {
        if (!NCConfig.radiation_hardcore_stacks) {
            return;
        }
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)stack, null, chunkSource);
        }
        for (ItemStack stack : inventory.field_70460_b) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)stack, null, chunkSource);
        }
        for (ItemStack stack : inventory.field_184439_c) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)stack, null, chunkSource);
        }
    }

    public static void spreadRadiationFromChunk(Chunk chunk, Chunk targetChunk) {
        if (chunk == null || !chunk.func_177410_o()) {
            return;
        }
        IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk);
        if (chunkSource == null || targetChunk == null || !targetChunk.func_177410_o()) {
            return;
        }
        IRadiationSource targetChunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)targetChunk);
        if (targetChunkSource != null && !chunkSource.isRadiationNegligible() && targetChunkSource.getScrubbingFraction() < 1.0) {
            double spreadMult = 1.0 - targetChunkSource.getScrubbingFraction();
            if (targetChunkSource.getRadiationLevel() == 0.0 || spreadMult == 0.0 || chunkSource.getRadiationLevel() / targetChunkSource.getRadiationLevel() > (1.0 + NCConfig.radiation_spread_gradient) / spreadMult) {
                double radiationSpread = (chunkSource.getRadiationLevel() - targetChunkSource.getRadiationLevel()) * NCConfig.radiation_spread_rate * spreadMult;
                chunkSource.setRadiationLevel(chunkSource.getRadiationLevel() - radiationSpread);
                targetChunkSource.setRadiationLevel(targetChunkSource.getRadiationLevel() + radiationSpread);
            }
        }
        chunkSource.setRadiationBuffer(0.0);
        if (chunkSource.isRadiationNegligible()) {
            chunkSource.setRadiationLevel(0.0);
        }
    }

    public static double addRadsToPlayer(EntityPlayer player, IEntityRads playerRads, double rawRadiation, int updateRate) {
        double resistance = playerRads.getRadiationResistance() + RadiationHelper.getPlayerArmorRadResistance(player);
        double addedRadiation = rawRadiation <= 0.0 ? 0.0 : NCMath.square(rawRadiation) / (rawRadiation + resistance);
        playerRads.setTotalRads(playerRads.getTotalRads() + addedRadiation * (double)updateRate, true);
        return addedRadiation;
    }

    public static double getPlayerArmorRadResistance(EntityPlayer player) {
        return RadiationHelper.getArmorInventoryRadResistance((Entity)player);
    }

    private static double getArmorInventoryRadResistance(Entity entity) {
        if (entity == null) {
            return 0.0;
        }
        double resistance = 0.0;
        for (ItemStack armor : entity.func_184193_aE()) {
            resistance += RadiationHelper.getArmorRadResistance(armor);
        }
        return resistance;
    }

    private static double getArmorRadResistance(ItemStack armor) {
        if (armor.func_190926_b()) {
            return 0.0;
        }
        double resistance = 0.0;
        IRadiationResistance armorResistance = RadiationHelper.getRadiationResistance((ICapabilityProvider)armor);
        if (armorResistance != null) {
            resistance += armorResistance.getRadiationResistance();
        }
        if (armor.func_77942_o() && armor.func_77978_p().func_74764_b("ncRadiationResistance")) {
            resistance += armor.func_77978_p().func_74769_h("ncRadiationResistance");
        }
        return resistance;
    }

    public static double addRadsToEntity(IEntityRads entityRads, EntityLiving entityLiving, double rawRadiation, int updateRate) {
        double resistance = entityRads.getRadiationResistance() + RadiationHelper.getEntityArmorRadResistance(entityLiving);
        double addedRadiation = rawRadiation <= 0.0 ? 0.0 : NCMath.square(rawRadiation) / (rawRadiation + resistance);
        entityRads.setTotalRads(entityRads.getTotalRads() + addedRadiation * (double)updateRate, true);
        return addedRadiation;
    }

    public static double getEntityArmorRadResistance(EntityLiving entityLiving) {
        double resistance = RadiationHelper.getArmorInventoryRadResistance((Entity)entityLiving);
        if (NCConfig.radiation_horse_armor_public && entityLiving instanceof EntityHorse) {
            resistance += RadiationHelper.getHorseArmorRadResistance((EntityHorse)entityLiving);
        }
        return resistance;
    }

    private static double getHorseArmorRadResistance(EntityHorse horse) {
        double resistance = 0.0;
        NBTTagCompound compound = new NBTTagCompound();
        horse.func_70014_b(compound);
        ItemStack armor = new ItemStack(compound.func_74775_l("ArmorItem"));
        if (ArmorHelper.isHorseArmor(armor.func_77973_b())) {
            resistance += RadiationHelper.getArmorRadResistance(armor);
        }
        return resistance;
    }

    public static double transferRadsFromInventoryToPlayer(IEntityRads playerRads, EntityPlayer player, int updateRate) {
        double radiationLevel = 0.0;
        InventoryPlayer inventory = player.field_71071_by;
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_190926_b()) continue;
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, playerRads, player, updateRate);
        }
        for (ItemStack stack : inventory.field_70460_b) {
            if (stack.func_190926_b()) continue;
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, playerRads, player, updateRate);
        }
        for (ItemStack stack : inventory.field_184439_c) {
            if (stack.func_190926_b()) continue;
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, playerRads, player, updateRate);
        }
        return radiationLevel;
    }

    private static double transferRadsFromStackToPlayer(ItemStack stack, IEntityRads playerRads, EntityPlayer player, int updateRate) {
        IRadiationSource stackSource = RadiationHelper.getRadiationSource((ICapabilityProvider)stack);
        if (stackSource == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToPlayer(player, playerRads, stackSource.getRadiationLevel() * (double)stack.func_190916_E(), updateRate);
    }

    public static double transferRadsToPlayer(IRadiationSource source, IEntityRads playerRads, EntityPlayer player, int updateRate) {
        if (source == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToPlayer(player, playerRads, source.getRadiationLevel(), updateRate);
    }

    public static double transferBackgroundRadsToPlayer(Biome biome, IEntityRads playerRads, EntityPlayer player, int updateRate) {
        Double biomeRadiation = RadBiomes.RAD_MAP.get(biome);
        if (biomeRadiation == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToPlayer(player, playerRads, biomeRadiation, updateRate);
    }

    public static void transferRadsFromSourceToEntity(IRadiationSource source, IEntityRads entityRads, EntityLiving entityLiving, int updateRate) {
        if (source == null) {
            return;
        }
        entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity(entityRads, entityLiving, source.getRadiationLevel(), updateRate));
    }

    public static void transferBackgroundRadsToEntity(Biome biome, IEntityRads entityRads, EntityLiving entityLiving, int updateRate) {
        Double biomeRadiation = RadBiomes.RAD_MAP.get(biome);
        if (biomeRadiation != null) {
            entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity(entityRads, entityLiving, biomeRadiation, updateRate));
        }
    }

    public static void applyPotionEffects(EntityLivingBase entity, IEntityRads entityRads, List<Double> radLevelList, List<List<PotionEffect>> potionList) {
        if (radLevelList.isEmpty() || radLevelList.size() != potionList.size()) {
            return;
        }
        double radPercentage = entityRads.getRadsPercentage();
        for (int i = 0; i < radLevelList.size(); ++i) {
            int j = radLevelList.size() - 1 - i;
            if (!(radPercentage >= radLevelList.get(j))) continue;
            for (PotionEffect potionEffect : potionList.get(j)) {
                entity.func_70690_d(new PotionEffect(potionEffect));
            }
            break;
        }
    }

    public static TextFormatting getRadsTextColor(IEntityRads playerRads) {
        double radsPercent = playerRads.getRadsPercentage();
        return radsPercent < 30.0 ? TextFormatting.WHITE : (radsPercent < 50.0 ? TextFormatting.YELLOW : (radsPercent < 70.0 ? TextFormatting.GOLD : (radsPercent < 90.0 ? TextFormatting.RED : TextFormatting.DARK_RED)));
    }

    public static TextFormatting getRadiationTextColor(double radiation) {
        if (radiation < 1.0E-9) {
            return TextFormatting.WHITE;
        }
        return radiation < 0.001 ? TextFormatting.YELLOW : (radiation < 0.1 ? TextFormatting.GOLD : (radiation < 1.0 ? TextFormatting.RED : TextFormatting.DARK_RED));
    }

    public static TextFormatting getRadiationTextColor(IRadiation irradiated) {
        return RadiationHelper.getRadiationTextColor(irradiated.getRadiationLevel());
    }

    public static String radsPrefix(double rads, boolean rate) {
        String unit = rate ? "Rads/t" : "Rads";
        return NCConfig.radiation_unit_prefixes > 0 ? NCMath.sigFigs(rads, NCConfig.radiation_unit_prefixes) + " " + unit : UnitHelper.prefix(rads, 3, unit, 0, -8);
    }
}

