/*
 * Decompiled with CFR 0.152.
 */
package nc.proxy;

import java.util.ArrayList;
import java.util.List;
import nc.block.fluid.NCBlockFluid;
import nc.config.NCConfig;
import nc.handler.RenderHandler;
import nc.handler.TooltipHandler;
import nc.init.NCCoolantFluids;
import nc.init.NCFissionFluids;
import nc.model.ModelTexturedFluid;
import nc.proxy.CommonProxy;
import nc.radiation.RadiationRenders;
import nc.render.ColorRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.Material;

public class ClientProxy
extends CommonProxy {
    private final Minecraft mc = Minecraft.func_71410_x();

    @Override
    public void preInit(FMLPreInitializationEvent preEvent) {
        super.preInit(preEvent);
        OBJLoader.INSTANCE.addDomain("nuclearcraft");
        NCConfig.clientPreInit();
        RenderHandler.init();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent postEvent) {
        super.postInit(postEvent);
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RadiationRenders(this.mc));
    }

    @Override
    public World getWorld(int dimensionId) {
        if (this.getCurrentClientDimension() != dimensionId) {
            return null;
        }
        return this.mc.field_71441_e;
    }

    @Override
    public int getCurrentClientDimension() {
        return this.mc.field_71441_e.field_73011_w.getDimension();
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? this.mc.field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        name = name.toLowerCase();
        super.registerFluidBlockRendering(block, name);
        FluidStateMapper mapper = new FluidStateMapper(name);
        Item item = Item.func_150898_a((Block)block);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @Override
    public void initFluidColors() {
        super.initFluidColors();
        ArrayList<Fluid> fluidList = new ArrayList<Fluid>();
        fluidList.addAll(NCCoolantFluids.fluidList);
        fluidList.addAll(NCFissionFluids.fluidList);
        this.initFluidColors(fluidList);
    }

    private <T extends Fluid> void initFluidColors(List<T> fluidList) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            BlockColors blockcolors = this.mc.func_184125_al();
            ItemColors itemcolors = this.mc.getItemColors();
            for (Fluid fluid : fluidList) {
                if (fluid.getBlock() == null || !NCBlockFluid.class.isAssignableFrom(fluid.getBlock().getClass())) continue;
                NCBlockFluid block = (NCBlockFluid)fluid.getBlock();
                blockcolors.func_186722_a((IBlockColor)new ColorRenderer.FluidBlockColor(block), new Block[]{block});
                itemcolors.func_186731_a((IItemColor)new ColorRenderer.FluidItemBlockColor(block), new Block[]{block});
            }
        }
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public void setRenderInfo(Material mat, int color) {
        mat.setRenderInfo(color);
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public void setRenderInfo(Material mat, int lo, int mid, int hi) {
        mat.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.MultiColor(lo, mid, hi));
    }

    static {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelTexturedFluid.FluidTexturedLoader.INSTANCE);
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(String name) {
            this.location = new ModelResourceLocation("nuclearcraft:fluids", name);
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return this.location;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.location;
        }
    }
}

