/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.saltFission.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.saltFission.SaltFissionHeaterSetting;
import nc.multiblock.saltFission.SaltFissionReactor;
import nc.multiblock.saltFission.tile.TileSaltFissionModerator;
import nc.multiblock.saltFission.tile.TileSaltFissionPartBase;
import nc.multiblock.saltFission.tile.TileSaltFissionVessel;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.RecipeMatchResult;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.tile.processor.IFluidProcessor;
import nc.util.BlockPosHelper;
import nc.util.GasHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSaltFissionHeater
extends TileSaltFissionPartBase
implements IFluidProcessor,
ITileFluid {
    @Nonnull
    private final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(2592, NCRecipes.coolant_heater_valid_fluids.get(0)), new Tank(5184, new ArrayList<String>())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{TankSorption.NON, TankSorption.NON}));
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    @Nonnull
    private GasTileWrapper gasWrapper;
    @Nonnull
    private SaltFissionHeaterSetting[] heaterSettings = new SaltFissionHeaterSetting[]{SaltFissionHeaterSetting.DISABLED, SaltFissionHeaterSetting.DISABLED, SaltFissionHeaterSetting.DISABLED, SaltFissionHeaterSetting.DISABLED, SaltFissionHeaterSetting.DISABLED, SaltFissionHeaterSetting.DISABLED};
    public final int fluidInputSize = 1;
    public final int fluidOutputSize = 1;
    public double baseProcessCooling;
    public final int baseProcessTime = 20;
    public double reactorCoolingEfficiency;
    public boolean checked = false;
    public boolean isInValidPosition;
    public double time;
    public boolean isProcessing;
    public boolean canProcessInputs;
    public final NCRecipes.Type recipeType = NCRecipes.Type.COOLANT_HEATER;
    protected RecipeInfo<ProcessorRecipe> recipeInfo;
    protected RecipeInfo<ProcessorRecipe> cachedRecipeInfo;
    protected int heaterCount;

    public TileSaltFissionHeater() {
        super(CuboidalPartPositionType.INTERIOR);
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
    }

    @Override
    public void onMachineAssembled(SaltFissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    public void checkIsInValidPosition(short heaterCheckCount) {
        String coolantName = this.getCoolantName();
        if (coolantName.equals("nullFluid")) {
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("nak") && heaterCheckCount == 0) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!this.isVessel(dir) && !this.isModerator(dir)) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("redstone_nak") && heaterCheckCount == 0) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!this.isVessel(dir)) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("quartz_nak") && heaterCheckCount == 0) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!this.isModerator(dir)) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("gold_nak") && heaterCheckCount == 1) {
            boolean nak = false;
            boolean redstone = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!nak && this.isHeaterWithCoolant(dir, "nak")) {
                    nak = true;
                }
                if (!redstone && this.isHeaterWithCoolant(dir, "redstone_nak")) {
                    redstone = true;
                }
                if (!nak || !redstone) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("glowstone_nak") && heaterCheckCount == 0) {
            int moderator = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (this.isModerator(dir)) {
                    moderator = (short)(moderator + 1);
                }
                if (moderator < 2) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("lapis_nak") && heaterCheckCount == 0) {
            boolean vessel = false;
            boolean wall = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!vessel && this.isVessel(dir)) {
                    vessel = true;
                }
                if (!wall && this.isWall(dir)) {
                    wall = true;
                }
                if (!vessel || !wall) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("diamond_nak") && heaterCheckCount == 1) {
            boolean nak = false;
            boolean quartz = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!nak && this.isHeaterWithCoolant(dir, "nak")) {
                    nak = true;
                }
                if (!quartz && this.isHeaterWithCoolant(dir, "quartz_nak")) {
                    quartz = true;
                }
                if (!nak || !quartz) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("liquidhelium_nak") && heaterCheckCount == 1) {
            boolean wall = false;
            int redstone = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!wall && this.isWall(dir)) {
                    wall = true;
                }
                if (this.isHeaterWithCoolant(dir, "redstone_nak")) {
                    redstone = (short)(redstone + 1);
                }
                if (redstone <= 1) continue;
                this.isInValidPosition = false;
                this.checked = true;
                return;
            }
            this.isInValidPosition = wall && redstone == 1;
            this.checked = true;
            return;
        }
        if (coolantName.equals("ender_nak") && heaterCheckCount == 0) {
            int vertices = 0;
            block8: for (EnumFacing[] vertexDirList : BlockPosHelper.vertexDirList()) {
                for (EnumFacing dir : vertexDirList) {
                    if (!this.isWall(dir)) continue block8;
                }
                if ((vertices = (int)((short)(vertices + 1))) <= 1) continue;
                this.isInValidPosition = false;
                this.checked = true;
                return;
            }
            this.isInValidPosition = vertices == 1;
            this.checked = true;
            return;
        }
        if (coolantName.equals("cryotheum_nak") && heaterCheckCount == 0) {
            int vessel = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (this.isVessel(dir)) {
                    vessel = (short)(vessel + 1);
                }
                if (vessel < 2) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("iron_nak") && heaterCheckCount == 2) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!this.isHeaterWithCoolant(dir, "gold_nak")) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("emerald_nak") && heaterCheckCount == 0) {
            boolean vessel = false;
            boolean moderator = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!vessel && this.isVessel(dir)) {
                    vessel = true;
                }
                if (!moderator && this.isModerator(dir)) {
                    moderator = true;
                }
                if (!vessel || !moderator) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("copper_nak") && heaterCheckCount == 1) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!this.isHeaterWithCoolant(dir, "glowstone_nak")) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("tin_nak") && heaterCheckCount == 1) {
            block14: for (EnumFacing[] axialsDirList : BlockPosHelper.axialsDirList()) {
                for (EnumFacing dir : axialsDirList) {
                    if (!this.isHeaterWithCoolant(dir, "lapis_nak")) continue block14;
                }
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        if (coolantName.equals("magnesium_nak") && heaterCheckCount == 0) {
            boolean moderator = false;
            boolean wall = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!moderator && this.isModerator(dir)) {
                    moderator = true;
                }
                if (!wall && this.isWall(dir)) {
                    wall = true;
                }
                if (!moderator || !wall) continue;
                this.isInValidPosition = true;
                this.checked = true;
                return;
            }
            this.isInValidPosition = false;
            this.checked = true;
            return;
        }
        this.isInValidPosition = false;
    }

    public String getCoolantName() {
        return this.tanks.get(0).getFluidName();
    }

    private boolean isWall(EnumFacing dir) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileSaltFissionPartBase)) {
            return false;
        }
        TileSaltFissionPartBase part = (TileSaltFissionPartBase)tile;
        return part.getPartPositionType() == CuboidalPartPositionType.WALL;
    }

    private boolean isHeaterWithCoolant(EnumFacing dir, String name) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileSaltFissionHeater)) {
            return false;
        }
        TileSaltFissionHeater heater = (TileSaltFissionHeater)tile;
        return heater.tanks.get(0).getFluidName().equals(name) && heater.isInValidPosition;
    }

    private boolean isModerator(EnumFacing dir) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileSaltFissionModerator)) {
            return false;
        }
        TileSaltFissionModerator moderator = (TileSaltFissionModerator)tile;
        return moderator.isInValidPosition;
    }

    private boolean isVessel(EnumFacing dir) {
        if (!this.isMultiblockAssembled()) {
            return false;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (!(tile instanceof TileSaltFissionVessel)) {
            return false;
        }
        TileSaltFissionVessel vessel = (TileSaltFissionVessel)tile;
        return vessel.canProcessInputs;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateHeater();
    }

    public void updateHeater() {
        if (!this.field_145850_b.field_72995_K) {
            this.setIsReactorOn();
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            this.tickHeater();
            if (this.isProcessing) {
                this.process();
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
            }
            if (this.heaterCount == 0) {
                this.pushFluid();
                this.refreshRecipe();
                this.refreshActivity();
            }
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void tickHeater() {
        ++this.heaterCount;
        this.heaterCount %= NCConfig.machine_update_rate / 2;
    }

    @Override
    public void refreshRecipe() {
        RecipeMatchResult matchResult;
        RecipeMatchResult recipeMatchResult = matchResult = this.recipeInfo == null ? RecipeMatchResult.FAIL : this.recipeInfo.getRecipe().matchInputs(new ArrayList<ItemStack>(), this.getFluidInputs());
        if (!matchResult.matches()) {
            matchResult = this.cachedRecipeInfo == null ? RecipeMatchResult.FAIL : this.cachedRecipeInfo.getRecipe().matchInputs(new ArrayList<ItemStack>(), this.getFluidInputs());
            this.recipeInfo = matchResult.matches() ? new RecipeInfo<ProcessorRecipe>(this.cachedRecipeInfo.getRecipe(), matchResult) : this.getRecipeHandler().getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs());
            if (this.recipeInfo != null) {
                this.cachedRecipeInfo = this.recipeInfo;
            }
        } else {
            this.recipeInfo = new RecipeInfo<ProcessorRecipe>(this.recipeInfo.getRecipe(), matchResult);
        }
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs(false);
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs(true);
    }

    public double getSpeedMultiplier() {
        return this.reactorCoolingEfficiency;
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessCooling = 0.0;
            return false;
        }
        this.baseProcessCooling = this.recipeInfo.getRecipe().getCoolantHeaterCoolingRate();
        return true;
    }

    public boolean isProcessing() {
        return this.readyToProcess() && this.isReactorOn;
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.isInValidPosition && this.isMultiblockAssembled();
    }

    public boolean canProcessInputs(boolean justProduced) {
        if (!this.setRecipeStats()) {
            return false;
        }
        if (!justProduced && this.time >= 20.0) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.tanks.get(j + 1).isEmpty()) continue;
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.tanks.get(j + 1).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.tanks.get(j + 1).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        if (this.time >= 20.0) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = 20.0;
        this.produceProducts();
        this.refreshRecipe();
        this.time = !this.setRecipeStats() ? 0.0 : MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)20.0);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        if (this.recipeInfo == null) {
            return;
        }
        List<Integer> fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            int fluidIngredientStackSize = this.getFluidIngredients().get(fluidInputOrder.get(i)).getMaxStackSize(this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (fluidIngredientStackSize > 0) {
                this.tanks.get(i).changeFluidAmount(-fluidIngredientStackSize);
            }
            if (this.tanks.get(i).getFluidAmount() > 0) continue;
            this.tanks.get(i).setFluidStored(null);
        }
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (this.tanks.get(j + 1).isEmpty()) {
                this.tanks.get(j + 1).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.tanks.get(j + 1).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
    }

    @Override
    public ProcessorRecipeHandler getRecipeHandler() {
        return this.recipeType.getRecipeHandler();
    }

    @Override
    public List<Tank> getFluidInputs() {
        return this.tanks.subList(0, 1);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().fluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().fluidProducts();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Nonnull
    public SaltFissionHeaterSetting[] getHeaterSettings() {
        return this.heaterSettings;
    }

    public void setHeaterSettings(@Nonnull SaltFissionHeaterSetting[] settings) {
        this.heaterSettings = settings;
    }

    public SaltFissionHeaterSetting getHeaterSetting(@Nonnull EnumFacing side) {
        return this.heaterSettings[side.func_176745_a()];
    }

    public void setHeaterSetting(@Nonnull EnumFacing side, @Nonnull SaltFissionHeaterSetting setting) {
        this.heaterSettings[side.func_176745_a()] = setting;
    }

    public void toggleHeaterSetting(@Nonnull EnumFacing side) {
        this.setHeaterSetting(side, this.getHeaterSetting(side).next());
        this.refreshFluidConnections(side);
        this.markAndRefresh();
    }

    public void refreshFluidConnections(@Nonnull EnumFacing side) {
        switch (this.getHeaterSetting(side)) {
            case DISABLED: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            case DEFAULT: {
                this.setTankSorption(side, 0, TankSorption.IN);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            case HOT_COOLANT_OUT: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.OUT);
                break;
            }
            case COOLANT_SPREAD: {
                this.setTankSorption(side, 0, TankSorption.OUT);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            default: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.NON);
            }
        }
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        block8: {
            TileEntity tile;
            SaltFissionHeaterSetting thisSetting;
            block5: {
                SaltFissionHeaterSetting heaterSetting;
                TileSaltFissionHeater heater;
                block6: {
                    block7: {
                        thisSetting = this.getHeaterSetting(side);
                        if (thisSetting == SaltFissionHeaterSetting.DISABLED) {
                            return;
                        }
                        tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
                        if (!(tile instanceof TileSaltFissionHeater)) break block5;
                        heater = (TileSaltFissionHeater)tile;
                        heaterSetting = heater.getHeaterSetting(side.func_176734_d());
                        if (thisSetting != SaltFissionHeaterSetting.COOLANT_SPREAD) break block6;
                        if (heaterSetting != SaltFissionHeaterSetting.DEFAULT) break block7;
                        this.pushCoolant(heater);
                        this.pushHotCoolant(heater);
                        break block8;
                    }
                    if (heaterSetting != SaltFissionHeaterSetting.HOT_COOLANT_OUT) break block8;
                    this.pushCoolant(heater);
                    break block8;
                }
                if (thisSetting != SaltFissionHeaterSetting.HOT_COOLANT_OUT || heaterSetting != SaltFissionHeaterSetting.DEFAULT && heaterSetting != SaltFissionHeaterSetting.COOLANT_SPREAD) break block8;
                this.pushHotCoolant(heater);
                break block8;
            }
            if (thisSetting == SaltFissionHeaterSetting.HOT_COOLANT_OUT) {
                IFluidHandler adjStorage;
                if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
                    return;
                }
                IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                if (adjStorage == null) {
                    return;
                }
                for (int i = 0; i < this.getTanks().size(); ++i) {
                    if (this.getTanks().get(i).getFluid() == null || !this.getTankSorption(side, i).canDrain()) continue;
                    this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
                }
            }
        }
    }

    public void pushCoolant(TileSaltFissionHeater other) {
        int diff = this.getTanks().get(0).getFluidAmount() - other.getTanks().get(0).getFluidAmount();
        if (diff > 1) {
            this.getTanks().get(0).drain(other.getTanks().get(0).fillInternal(this.getTanks().get(0).drain(diff / 2, false), true), true);
        }
    }

    public void pushHotCoolant(TileSaltFissionHeater other) {
        this.getTanks().get(1).drain(other.getTanks().get(1).fillInternal(this.getTanks().get(1).drain(this.getTanks().get(1).getCapacity(), false), true), true);
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public boolean getVoidExcessFluidOutput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidExcessFluidOutput(int tankNumber, boolean voidExcessFluidOutput) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    public NBTTagCompound writeHeaterSettings(NBTTagCompound nbt) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            settingsTag.func_74768_a("setting" + side.func_176745_a(), this.getHeaterSetting(side).ordinal());
        }
        nbt.func_74782_a("heaterSettings", (NBTBase)settingsTag);
        return nbt;
    }

    public void readHeaterSettings(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fluidConnections0")) {
            block6: for (EnumFacing side : EnumFacing.field_82609_l) {
                TankSorption sorption = TankSorption.values()[nbt.func_74762_e("fluidConnections" + side.func_176745_a())];
                switch (sorption) {
                    case NON: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setHeaterSetting(side, SaltFissionHeaterSetting.DISABLED);
                        continue block6;
                    }
                    case BOTH: {
                        this.setTankSorption(side, 0, TankSorption.IN);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setHeaterSetting(side, SaltFissionHeaterSetting.DEFAULT);
                        continue block6;
                    }
                    case IN: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.OUT);
                        this.setHeaterSetting(side, SaltFissionHeaterSetting.HOT_COOLANT_OUT);
                        continue block6;
                    }
                    case OUT: {
                        this.setTankSorption(side, 0, TankSorption.OUT);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setHeaterSetting(side, SaltFissionHeaterSetting.COOLANT_SPREAD);
                        continue block6;
                    }
                    default: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setHeaterSetting(side, SaltFissionHeaterSetting.DISABLED);
                    }
                }
            }
        } else {
            NBTTagCompound settingsTag = nbt.func_74775_l("heaterSettings");
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.setHeaterSetting(side, SaltFissionHeaterSetting.values()[settingsTag.func_74762_e("setting" + side.func_176745_a())]);
                this.refreshFluidConnections(side);
            }
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeHeaterSettings(nbt);
        nbt.func_74780_a("baseProcessCooling", this.baseProcessCooling);
        nbt.func_74780_a("reactorCoolingRate", this.reactorCoolingEfficiency);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74757_a("isInValidPosition", this.isInValidPosition);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readHeaterSettings(nbt);
        this.baseProcessCooling = nbt.func_74769_h("baseProcessCooling");
        this.reactorCoolingEfficiency = nbt.func_74769_h("reactorCoolingRate");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.isInValidPosition = nbt.func_74767_n("isInValidPosition");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return true;
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return true;
            }
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return (T)this.getGasWrapper();
            }
        }
        return super.getCapability(capability, side);
    }
}

