/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import nc.capability.ICapability;
import nc.capability.radiation.entity.EntityRads;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.capability.radiation.resistance.RadiationResistance;
import nc.capability.radiation.sink.IRadiationSink;
import nc.capability.radiation.sink.RadiationSink;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSource;
import nc.config.NCConfig;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityHandler {
    public static void init() {
        CapabilityHandler.registerCapability(IEntityRads.class, new EntityRads(NCConfig.max_player_rads));
        CapabilityHandler.registerCapability(IRadiationSource.class, new RadiationSource(0.0));
        CapabilityHandler.registerCapability(IRadiationResistance.class, new RadiationResistance(0.0));
        CapabilityHandler.registerCapability(IRadiationSink.class, new RadiationSink(0.0));
    }

    public static <T extends ICapability> void registerCapability(Class<T> clazz, T defaultImpl) {
        CapabilityManager.INSTANCE.register(clazz, new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                NBTTagCompound nbt = new NBTTagCompound();
                return instance.writeNBT(instance, side, nbt);
            }

            public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagCompound) {
                    instance.readNBT(instance, side, (NBTTagCompound)nbt);
                }
            }
        }, () -> defaultImpl);
    }
}

