/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.processor;

import com.google.common.collect.Lists;
import java.util.List;
import nc.container.processor.ContainerItemFluidProcessor;
import nc.gui.NCGui;
import nc.gui.element.NCGuiButton;
import nc.tile.energy.ITileEnergy;
import nc.tile.processor.TileItemFluidProcessor;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiItemFluidProcessor
extends NCGui {
    protected TileItemFluidProcessor tile;
    protected final ResourceLocation gui_textures;

    public GuiItemFluidProcessor(String name, EntityPlayer player, ContainerItemFluidProcessor inv) {
        super(inv);
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/" + name + ".png");
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected int getCookProgressScaled(double pixels) {
        double i = this.tile.time;
        double j = this.tile.baseProcessTime;
        return j != 0.0 ? (int)Math.round(i * pixels / j) : 0;
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (!this.tile.func_145831_w().field_72995_K || guiButton == null || guiButton instanceof NCGuiButton.Button) {
            // empty if block
        }
    }

    @Override
    public void drawEnergyTooltip(ITileEnergy tile, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (this.tile.defaultProcessPower != 0) {
            super.drawEnergyTooltip(tile, mouseX, mouseY, x, y, width, height);
        } else {
            this.drawNoEnergyTooltip(mouseX, mouseY, x, y, width, height);
        }
    }

    @Override
    public List<String> energyInfo(ITileEnergy tile) {
        String energy = UnitHelper.prefix((long)tile.getEnergyStorage().getEnergyStored(), (long)tile.getEnergyStorage().getMaxEnergyStored(), 5, "RF");
        String power = UnitHelper.prefix(this.tile.getProcessPower(), 5, "RF/t");
        String speedMult = this.tile.getSpeedMultiplier() == (double)((int)this.tile.getSpeedMultiplier()) ? new Integer((int)this.tile.getSpeedMultiplier()).toString() : new Double(NCMath.round(this.tile.getSpeedMultiplier(), 2)).toString();
        String powerMult = this.tile.getPowerMultiplier() == (double)((int)this.tile.getPowerMultiplier()) ? new Integer((int)this.tile.getPowerMultiplier()).toString() : new Double(NCMath.round(this.tile.getPowerMultiplier(), 2)).toString();
        String speedMultiplier = "x" + speedMult;
        String powerMultiplier = "x" + powerMult;
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.energy_stored") + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.process_power") + TextFormatting.WHITE + " " + power, TextFormatting.AQUA + Lang.localise("gui.container.speed_multiplier") + TextFormatting.WHITE + " " + speedMultiplier, TextFormatting.AQUA + Lang.localise("gui.container.power_multiplier") + TextFormatting.WHITE + " " + powerMultiplier});
    }
}

