/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.blocks.BlockCoconut;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.world.trees.enumTypes.EnumDirection;

public class WorldGenIslandPalm
extends WorldGenAbstractTree {
    public final IBlockState TRUNK = ModBlocks.WOOD_LOOKUP.get("LOG_PALM").func_176223_P();
    public static final IBlockState LEAF = ModBlocks.LEAVES_ISLAND_PALM.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private final int minheight;

    public WorldGenIslandPalm() {
        super(false);
        this.minheight = 7;
    }

    public WorldGenIslandPalm(boolean notify, int minHeight) {
        super(notify);
        this.minheight = minHeight;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        boolean isSoil;
        EnumDirection leaning1;
        if (worldIn.func_180494_b(pos).func_150561_m() == Biome.TempCategory.COLD) {
            return false;
        }
        int height = this.minheight + rand.nextInt(6);
        EnumDirection leaning0 = EnumDirection.getRandomEnumDirectional(rand);
        if (leaning0 == (leaning1 = EnumDirection.getRandomEnumDirectional(rand)) || leaning0 == leaning1.getFullOpposite()) {
            leaning1 = EnumDirection.VERTICAL_TRUE;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean flag = true;
        for (int yPos = 0; yPos <= height + 3; ++yPos) {
            if (yPos >= 0 && yPos < worldIn.func_72800_K()) {
                BlockPos pos21;
                BlockPos blockPos = yPos > 0 ? (yPos > 2 ? pos.func_177982_a(2 * leaning0.getXOffset() + 2 * leaning1.getXOffset(), yPos, 2 * leaning0.getZOffset() + 2 * leaning1.getZOffset()) : pos.func_177982_a(leaning0.getXOffset() + leaning1.getXOffset(), yPos, leaning0.getZOffset() + leaning1.getZOffset())) : (pos21 = pos.func_177981_b(yPos));
                if (this.isReplaceable(worldIn, pos21)) continue;
                flag = false;
                continue;
            }
            flag = false;
        }
        if (!flag) {
            return false;
        }
        BlockPos down = pos.func_177977_b();
        IBlockState state = worldIn.func_180495_p(down);
        boolean bl = isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)ModBlocks.SAPLING_PALM) || state.func_177230_c() == Blocks.field_150354_m;
        if (isSoil && y < worldIn.func_72800_K() - height - 1) {
            state.func_177230_c().onPlantGrow(state, worldIn, down, pos);
            BlockPos generateLeavesFrom = pos.func_177982_a(2 * leaning0.getXOffset() + 2 * leaning1.getXOffset(), height - 1, 2 * leaning0.getZOffset() + 2 * leaning1.getZOffset());
            this.generateLeaves(worldIn, generateLeavesFrom);
            this.addCoconutSpread(worldIn, generateLeavesFrom.func_177977_b(), rand, 1);
            for (int lHeight = 0; lHeight <= height; ++lHeight) {
                BlockPos pos21 = new BlockPos(0, 0, 0);
                pos21 = lHeight > 0 ? (lHeight > 2 ? pos.func_177982_a(2 * leaning0.getXOffset() + 2 * leaning1.getXOffset(), lHeight, 2 * leaning0.getZOffset() + 2 * leaning1.getZOffset()) : pos.func_177982_a(leaning0.getXOffset() + leaning1.getXOffset(), lHeight, leaning0.getZOffset() + leaning1.getZOffset())) : pos.func_177981_b(lHeight);
                this.func_175903_a(worldIn, pos21, this.TRUNK);
            }
            return true;
        }
        return false;
    }

    private void placeCoconut(World worldIn, BlockPos pos, Random rand) {
        this.func_175903_a(worldIn, pos, ModBlocks.COCONUT.func_176223_P().func_177226_a((IProperty)BlockCoconut.AGE, (Comparable)Integer.valueOf(rand.nextInt(2))));
    }

    private void generateLeaves(World worldIn, BlockPos pos) {
        this.setLeafPoints(worldIn, pos.func_177979_c(2), 2);
        this.setLeafPoints(worldIn, pos.func_177977_b(), 1);
        this.setLeafPoints(worldIn, pos.func_177977_b(), 2);
        this.setLeafSpread(worldIn, pos.func_177977_b(), 2);
        this.setLeafPoints(worldIn, pos, 1);
        this.setLeafSpread(worldIn, pos, 1);
        this.setLeafPoints(worldIn, pos.func_177984_a(), 1);
        this.setLeafPoints(worldIn, pos.func_177981_b(2), 1);
        this.setLeafPoints(worldIn, pos.func_177981_b(2), 2);
    }

    private void setLeaves(World worldIn, BlockPos pos) {
        if (this.func_150523_a(worldIn.func_180495_p(pos).func_177230_c())) {
            this.func_175903_a(worldIn, pos, LEAF);
        }
    }

    private void setLeafPoints(World worldIn, BlockPos pos, int range) {
        this.setLeaves(worldIn, pos.func_177982_a(range, 0, 0));
        this.setLeaves(worldIn, pos.func_177982_a(-range, 0, 0));
        this.setLeaves(worldIn, pos.func_177982_a(0, 0, range));
        this.setLeaves(worldIn, pos.func_177982_a(0, 0, -range));
    }

    private void setLeafSpread(World worldIn, BlockPos pos, int range) {
        this.setLeaves(worldIn, pos.func_177982_a(range, 0, range));
        this.setLeaves(worldIn, pos.func_177982_a(-range, 0, range));
        this.setLeaves(worldIn, pos.func_177982_a(range, 0, -range));
        this.setLeaves(worldIn, pos.func_177982_a(-range, 0, -range));
    }

    private void addCoconutSpread(World worldIn, BlockPos pos, Random rand, int range) {
        this.placeCoconut(worldIn, pos.func_177982_a(range, 0, range), rand);
        this.placeCoconut(worldIn, pos.func_177982_a(-range, 0, range), rand);
        this.placeCoconut(worldIn, pos.func_177982_a(range, 0, -range), rand);
        this.placeCoconut(worldIn, pos.func_177982_a(-range, 0, -range), rand);
    }
}

