/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.biomes.alpha5.bush;

import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeAssets;
import valoeghese.valoeghesesbe.world.trees.WorldGenManukaTree;

public class BiomeBushCanyon
extends Biome
implements BiomeAssets {
    private long worldSeed;
    private NoiseGeneratorPerlin pillarNoise;
    private NoiseGeneratorPerlin pillarRoofNoise;
    private NoiseGeneratorPerlin clayBandsOffsetNoise;

    public BiomeBushCanyon(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76760_I.field_76832_z = 20;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (rand.nextInt(4) == 0) {
            return new WorldGenShrub(Blocks.field_150364_r.func_176223_P(), BUSH_LEAVES);
        }
        return new WorldGenManukaTree();
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (this.pillarNoise == null || this.pillarRoofNoise == null || this.worldSeed != worldIn.func_72905_C()) {
            Random random = new Random(this.worldSeed);
            this.pillarNoise = new NoiseGeneratorPerlin(random, 4);
            this.pillarRoofNoise = new NoiseGeneratorPerlin(random, 1);
        }
        this.worldSeed = worldIn.func_72905_C();
        double d4 = 0.0;
        int i = (x & 0xFFFFFFF0) + (z & 0xF);
        int j = (z & 0xFFFFFFF0) + (x & 0xF);
        double d0 = Math.min(Math.abs(noiseVal), this.pillarNoise.func_151601_a((double)i * 0.25, (double)j * 0.25));
        if (d0 > 0.0) {
            double d1 = 0.001953125;
            d4 = d0 * d0 * 2.5;
            double d2 = Math.abs(this.pillarRoofNoise.func_151601_a((double)i * 0.001953125, (double)j * 0.001953125));
            double d3 = Math.ceil(d2 * 50.0) + 14.0;
            if (d4 > d3) {
                d4 = d3;
            }
            d4 += 64.0;
        }
        int k1 = x & 0xF;
        int l1 = z & 0xF;
        int i2 = worldIn.func_181545_F();
        IBlockState iblockstate = ROCK;
        IBlockState iblockstate3 = this.field_76753_B;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        boolean flag = Math.cos(noiseVal / 3.0 * Math.PI) > 0.0;
        int l = -1;
        boolean flag1 = false;
        int i1 = 0;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (chunkPrimerIn.func_177856_a(l1, j1, k1).func_185904_a() == Material.field_151579_a && j1 < (int)d4) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, ROCK);
            }
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, field_185367_c);
                continue;
            }
            IBlockState iblockstate1 = chunkPrimerIn.func_177856_a(l1, j1, k1);
            if (iblockstate1.func_185904_a() == Material.field_151579_a) {
                l = -1;
                continue;
            }
            if (iblockstate1.func_177230_c() != Blocks.field_150348_b) continue;
            if (l == -1) {
                flag1 = false;
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate3 = ROCK;
                } else if (j1 >= i2 - 4 && j1 <= i2 + 1) {
                    iblockstate = ROCK;
                    iblockstate3 = this.field_76753_B;
                }
                l = k + Math.max(0, j1 - i2);
                if (j1 >= i2 - 1) {
                    if (j1 > 86 + k * 2) {
                        if (flag) {
                            chunkPrimerIn.func_177855_a(l1, j1, k1, COARSE_DIRT);
                        } else {
                            chunkPrimerIn.func_177855_a(l1, j1, k1, GRASS);
                        }
                    } else if (j1 > i2 + 3 + k) {
                        IBlockState iblockstate2 = j1 >= 64 && j1 <= 127 ? (rand.nextBoolean() ? GRASS : Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL)) : ROCK;
                        chunkPrimerIn.func_177855_a(l1, j1, k1, iblockstate2);
                    } else {
                        chunkPrimerIn.func_177855_a(l1, j1, k1, this.field_76752_A);
                        flag1 = true;
                    }
                } else {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, iblockstate3);
                }
            } else if (l > 0) {
                --l;
                chunkPrimerIn.func_177855_a(l1, j1, k1, ROCK);
            }
            ++i1;
        }
    }
}

