/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.recipe;

import arcaratus.bloodarsenal.recipe.RecipeSanguineInfusion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class SanguineInfusionRecipeRegistry {
    private static List<RecipeSanguineInfusion> infusionRecipes = new ArrayList<RecipeSanguineInfusion>();
    private static List<Class> blacklistedClasses = new ArrayList<Class>();

    @SafeVarargs
    public static void registerSanguineInfusionRecipe(ItemStack output, int lpCost, ItemStack infuse, Pair<Object, Integer> ... inputs) {
        RecipeSanguineInfusion recipe = new RecipeSanguineInfusion(output, lpCost, infuse, inputs);
        infusionRecipes.add(recipe);
    }

    @SafeVarargs
    public static void registerModificationRecipe(int lpCost, String modifierKey, int levelMultiplier, Pair<Object, Integer> ... inputs) {
        RecipeSanguineInfusion recipe = new RecipeSanguineInfusion(lpCost, modifierKey, inputs).setLevelMultiplier(levelMultiplier);
        infusionRecipes.add(recipe);
    }

    @SafeVarargs
    public static void registerModificationRecipe(int lpCost, String modifierKey, int levelMultiplier, Class specialClass, Pair<Object, Integer> ... inputs) {
        RecipeSanguineInfusion recipe = new RecipeSanguineInfusion(lpCost, modifierKey, inputs).setLevelMultiplier(levelMultiplier);
        infusionRecipes.add(recipe);
        blacklistedClasses.add(specialClass);
    }

    public static List<RecipeSanguineInfusion> getInfusionRecipes() {
        return infusionRecipes;
    }

    public static List<Class> getBlacklistedClasses() {
        return blacklistedClasses;
    }

    public static RecipeSanguineInfusion getRecipeFromInputs(ItemStack infuseStack, List<ItemStack> inputs) {
        for (RecipeSanguineInfusion recipe : infusionRecipes) {
            if (!recipe.matches(infuseStack, inputs)) continue;
            return recipe;
        }
        return null;
    }
}

