/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.item.sigil;

import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.client.key.IKeybindable;
import WayofTime.bloodmagic.client.key.KeyBindings;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.iface.IAltarReader;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.iface.ISigil;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.BloodArsenal;
import arcaratus.bloodarsenal.item.sigil.ItemSigilBase;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSigilAugmentedHolding
extends ItemSigilBase
implements IKeybindable,
IAltarReader,
ISigil.Holding,
IMeshProvider {
    public static final int INVENTORY_SIZE = 9;

    public ItemSigilAugmentedHolding() {
        super("augmented_holding");
    }

    public void onKeyPressed(ItemStack stack, EntityPlayer player, KeyBindings key, boolean showInChat) {
        if (stack == player.func_184614_ca() && stack.func_77973_b() instanceof ItemSigilAugmentedHolding && key.equals((Object)KeyBindings.OPEN_HOLDING)) {
            Utils.setUUID((ItemStack)stack);
            player.openGui((Object)BloodArsenal.INSTANCE, 0, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        int currentSlot;
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        ItemStack item = inv.get(currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack));
        if (item.func_190926_b()) {
            return displayName;
        }
        return TextHelper.localizeEffect((String)"item.bloodmagic.sigil.holding.display", (Object[])new Object[]{displayName, item.func_82833_r()});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodmagic.sigil.holding.press", (Object[])new Object[]{KeyBindings.OPEN_HOLDING.getKey().getDisplayName()}));
        if (!stack.func_77942_o()) {
            return;
        }
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        int currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack);
        ItemStack item = inv.get(currentSlot);
        for (int i = 0; i < 9; ++i) {
            ItemStack invStack = inv.get(i);
            if (invStack.func_190926_b()) continue;
            if (!item.func_190926_b() && invStack == item) {
                tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodmagic.sigil.holding.sigilInSlot", (Object[])new Object[]{i + 1, "&o&n" + invStack.func_82833_r()}));
                continue;
            }
            tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodmagic.sigil.holding.sigilInSlot", (Object[])new Object[]{i + 1, invStack.func_82833_r()}));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return EnumActionResult.FAIL;
        }
        int currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack);
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        ItemStack itemUsing = inv.get(currentSlot);
        if (itemUsing.func_190926_b() || ((IBindable)itemUsing.func_77973_b()).getBinding(itemUsing) == null) {
            return EnumActionResult.PASS;
        }
        EnumActionResult result = itemUsing.func_77973_b().func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        this.saveInventory(stack, inv);
        return result;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        int currentSlot = ItemSigilAugmentedHolding.getCurrentItemOrdinal(stack);
        List<ItemStack> inv = ItemSigilAugmentedHolding.getInternalInventory(stack);
        ItemStack itemUsing = inv.get(currentSlot);
        if (itemUsing.func_190926_b() || ((IBindable)itemUsing.func_77973_b()).getBinding(itemUsing) == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        itemUsing.func_77973_b().func_77659_a(world, player, hand);
        this.saveInventory(stack, inv);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public ItemStack getHeldItem(ItemStack holdingStack, EntityPlayer player) {
        return ItemSigilAugmentedHolding.getInternalInventory(holdingStack).get(ItemSigilAugmentedHolding.getCurrentItemOrdinal(holdingStack));
    }

    public void saveInventory(ItemStack itemStack, List<ItemStack> inventory) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            if (inventory.get(i).func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            inventory.get(i).func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        itemTag.func_74782_a("Items", (NBTBase)itemList);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!itemStack.func_77942_o()) {
            this.tickInternalInventory(itemStack, world, entity, itemSlot, isSelected);
        }
    }

    public void tickInternalInventory(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        for (ItemStack stack : ItemSigilAugmentedHolding.getInternalInventory(itemStack)) {
            Binding binding;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IBindable) || !(stack.func_77973_b() instanceof ISigil) || (binding = ((IBindable)stack.func_77973_b()).getBinding(stack)) == null) continue;
            stack.func_77973_b().func_77663_a(stack, world, entity, itemSlot, isSelected);
        }
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
    }

    public ItemMeshDefinition getMeshDefinition() {
        return stack -> {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("color")) {
                return new ModelResourceLocation(this.getRegistryName(), "type=color");
            }
            return new ModelResourceLocation(this.getRegistryName(), "type=normal");
        };
    }

    public void gatherVariants(Consumer<String> variants) {
        variants.accept("type=normal");
        variants.accept("type=color");
    }

    public static int next(int mode) {
        int index = mode + 1;
        if (index >= 9) {
            index = 0;
        }
        return index;
    }

    public static int prev(int mode) {
        int index = mode - 1;
        if (index < 0) {
            index = 9;
        }
        return index;
    }

    private static void initModeTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack = NBTHelper.checkNBT((ItemStack)stack);
            stack.func_77978_p().func_74768_a("currentSigil", 9);
        }
    }

    public static ItemStack getItemStackInSlot(ItemStack itemStack, int slot) {
        if (itemStack.func_77973_b() instanceof ItemSigilAugmentedHolding) {
            List<ItemStack> itemStacks = ItemSigilAugmentedHolding.getInternalInventory(itemStack);
            if (!itemStacks.isEmpty()) {
                return itemStacks.get(slot == 9 ? 8 : slot);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public static int getCurrentItemOrdinal(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemSigilAugmentedHolding) {
            ItemSigilAugmentedHolding.initModeTag(itemStack);
            int currentSigil = itemStack.func_77978_p().func_74762_e("currentSigil");
            currentSigil = MathHelper.func_76125_a((int)currentSigil, (int)0, (int)8);
            return currentSigil;
        }
        return 0;
    }

    public static List<ItemStack> getInternalInventory(ItemStack stack) {
        ItemSigilAugmentedHolding.initModeTag(stack);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        if (tagList.func_82582_d()) {
            return NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        }
        NonNullList inv = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound data = tagList.func_150305_b(i);
            byte j = data.func_74771_c("Slot");
            if (j < 0 || j >= inv.size()) continue;
            inv.set(j, new ItemStack(data));
        }
        return inv;
    }

    public static void cycleToNextSigil(ItemStack itemStack, int mode) {
        if (itemStack.func_77973_b() instanceof ItemSigilAugmentedHolding) {
            ItemSigilAugmentedHolding.initModeTag(itemStack);
            int index = mode;
            if (mode == 120 || mode == -120) {
                int currentIndex = ItemSigilAugmentedHolding.getCurrentItemOrdinal(itemStack);
                ItemStack currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, currentIndex);
                if (currentItemStack.func_190926_b()) {
                    return;
                }
                if (mode < 0) {
                    index = BloodArsenalUtils.next(currentIndex, 9);
                    currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.func_190926_b()) {
                        index = BloodArsenalUtils.next(currentIndex, 9);
                        currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    }
                } else {
                    index = BloodArsenalUtils.prev(currentIndex, 9);
                    currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.func_190926_b()) {
                        index = BloodArsenalUtils.prev(currentIndex, 9);
                        currentItemStack = ItemSigilAugmentedHolding.getItemStackInSlot(itemStack, index);
                    }
                }
            }
            itemStack.func_77978_p().func_74768_a("currentSigil", index);
        }
    }
}

