/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.ArtisanRegistries;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ISecondaryIngredientMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeRegistry;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementContext;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.RequirementContextSupplier;
import com.codetaylor.mc.artisanworktables.modules.toolbox.tile.TileEntityToolbox;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktables;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktablesConfig;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.Container;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.GuiContainerBase;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.CPacketWorktableFluidUpdate;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.CraftingContextFactory;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.CraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.ITileEntityDesigner;
import com.codetaylor.mc.athenaeum.inventory.IObservableStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.tile.IContainer;
import com.codetaylor.mc.athenaeum.tile.IContainerProvider;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.EnchantmentHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class TileEntityBase
extends TileEntity
implements IContainer,
IContainerProvider<Container, GuiContainerBase> {
    private String uuid;
    private EnumType type;
    private ObservableStackHandler toolHandler;
    private CraftingMatrixStackHandler craftingMatrixHandler;
    private ObservableStackHandler secondaryOutputHandler;
    private FluidTank tank;
    private boolean initialized;
    private List<Container> containerList = new ArrayList<Container>();

    protected TileEntityBase() {
    }

    public TileEntityBase(EnumType type) {
        this.type = type;
        this.initializeInternal(type);
    }

    private void initializeInternal(EnumType type) {
        if (!this.initialized) {
            this.initialize(type);
            this.initialized = true;
        }
    }

    protected void initialize(EnumType type) {
        this.uuid = type.func_176610_l() + "." + this.getTier().getName();
        this.craftingMatrixHandler = this.createCraftingMatrixHandler();
        this.toolHandler = this.createToolHandler();
        this.secondaryOutputHandler = this.createSecondaryOutputHandler();
        this.tank = this.createFluidTank(type);
        IObservableStackHandler.IContentsChangedEventHandler contentsChangedEventHandler = (stackHandler, slotIndex) -> {
            this.func_70296_d();
            this.triggerContainerRecipeUpdate();
        };
        this.craftingMatrixHandler.addObserver(contentsChangedEventHandler);
        this.toolHandler.addObserver(contentsChangedEventHandler);
        this.secondaryOutputHandler.addObserver(contentsChangedEventHandler);
    }

    protected FluidTank createFluidTank(EnumType type) {
        return new FluidTank(this.getFluidTankCapacity(type)){

            protected void onContentsChanged() {
                TileEntityBase.this.onFluidTankContentsChanged();
            }
        };
    }

    protected void onFluidTankContentsChanged() {
        this.triggerContainerRecipeUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ModuleWorktables.PACKET_SERVICE.sendToAllAround((IMessage)new CPacketWorktableFluidUpdate(this.func_174877_v(), this.tank), (TileEntity)this);
        }
    }

    public void onJoinedBlockBreak(BlockPos pos) {
        for (Container container : this.containerList) {
            container.onJoinedBlockBreak(this.field_145850_b, pos);
        }
    }

    public void addContainer(Container container) {
        this.containerList.add(container);
    }

    public void removeContainer(Container container) {
        this.containerList.remove((Object)container);
    }

    public void triggerContainerRecipeUpdate() {
        for (Container container : this.containerList) {
            container.updateRecipeOutput();
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public ItemStackHandler getToolHandler() {
        return this.toolHandler;
    }

    public ICraftingMatrixStackHandler getCraftingMatrixHandler() {
        return this.craftingMatrixHandler;
    }

    public ItemStackHandler getSecondaryOutputHandler() {
        return this.secondaryOutputHandler;
    }

    protected String getWorktableName() {
        return this.type.func_176610_l();
    }

    protected int getGuiTextShadowColor() {
        return ModuleWorktablesConfig.CLIENT.getTextHighlightColor(this.type.func_176610_l());
    }

    public boolean canHandleRecipeTransferJEI(String name, EnumTier tier) {
        return this.type.func_176610_l().equals(name) && tier.getId() <= this.getTier().getId();
    }

    public int getWorktableGuiTabTextureYOffset() {
        return this.type.getGuiTabTextureOffsetY();
    }

    public EnumType getType() {
        return this.type;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public List<ItemStack> getBlockBreakDrops() {
        int i;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < this.toolHandler.getSlots(); ++i2) {
            ItemStack itemStack = this.toolHandler.getStackInSlot(i2);
            if (itemStack.func_190926_b()) continue;
            result.add(itemStack);
        }
        int slotCount = this.craftingMatrixHandler.getSlots();
        for (i = 0; i < slotCount; ++i) {
            ItemStack itemStack = this.craftingMatrixHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            result.add(itemStack);
        }
        if (this.secondaryOutputHandler != null) {
            for (i = 0; i < this.secondaryOutputHandler.getSlots(); ++i) {
                result.add(this.secondaryOutputHandler.getStackInSlot(i));
            }
        }
        return result;
    }

    public boolean canPlayerUse(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("type", this.type.getMeta());
        tag.func_74782_a("craftingMatrixHandler", (NBTBase)this.craftingMatrixHandler.serializeNBT());
        tag.func_74782_a("toolHandler", (NBTBase)this.toolHandler.serializeNBT());
        tag.func_74782_a("secondaryOutputHandler", (NBTBase)this.secondaryOutputHandler.serializeNBT());
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.type = EnumType.fromMeta(tag.func_74762_e("type"));
        this.initializeInternal(this.type);
        this.craftingMatrixHandler.deserializeNBT(tag.func_74775_l("craftingMatrixHandler"));
        this.toolHandler.deserializeNBT(tag.func_74775_l("toolHandler"));
        this.secondaryOutputHandler.deserializeNBT(tag.func_74775_l("secondaryOutputHandler"));
        this.tank.readFromNBT(tag.func_74775_l("tank"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onTakeResult(EntityPlayer player) {
        IArtisanRecipe recipe = this.getRecipe(player);
        if (recipe == null) {
            return;
        }
        recipe.doCraft(this.getCraftingContext(player));
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.notifyBlockUpdate();
        }
    }

    public ICraftingContext getCraftingContext(EntityPlayer player) {
        return CraftingContextFactory.createContext(this, player, null);
    }

    public void notifyBlockUpdate() {
        this.func_70296_d();
        BlockHelper.notifyBlockUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    public IArtisanRecipe getRecipe(@Nonnull EntityPlayer player) {
        FluidStack fluidStack = this.getTank().getFluid();
        if (fluidStack != null) {
            fluidStack = fluidStack.copy();
        }
        int playerExperience = EnchantmentHelper.getPlayerExperienceTotal((EntityPlayer)player);
        int playerLevels = player.field_71068_ca;
        boolean isPlayerCreative = player.func_184812_l_();
        IForgeRegistry<RequirementContextSupplier> contextSupplierRegistry = ArtisanRegistries.REQUIREMENT_CONTEXT_SUPPLIER;
        HashMap<ResourceLocation, IRequirementContext> contextMap = new HashMap<ResourceLocation, IRequirementContext>();
        ICraftingContext craftingContext = this.getCraftingContext(player);
        for (Map.Entry entry : contextSupplierRegistry.getEntries()) {
            RequirementContextSupplier contextSupplier = (RequirementContextSupplier)entry.getValue();
            IRequirementContext context = contextSupplier.get();
            context.initialize(craftingContext);
            contextMap.put((ResourceLocation)entry.getKey(), context);
        }
        return this.getWorktableRecipeRegistry().findRecipe(playerExperience, playerLevels, isPlayerCreative, this.getTools(), this.craftingMatrixHandler, fluidStack, this.getSecondaryIngredientMatcher(), this.getTier(), contextMap);
    }

    public ISecondaryIngredientMatcher getSecondaryIngredientMatcher() {
        return ISecondaryIngredientMatcher.FALSE;
    }

    public ItemStack[] getTools() {
        int slotCount = this.toolHandler.getSlots();
        ItemStack[] tools = new ItemStack[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            tools[i] = this.toolHandler.getStackInSlot(i);
        }
        return tools;
    }

    public boolean hasTool() {
        ItemStack[] tools = this.getTools();
        boolean hasTool = false;
        for (ItemStack tool : tools) {
            if (tool.func_190926_b()) continue;
            hasTool = true;
            break;
        }
        return hasTool;
    }

    public List<TileEntityBase> getJoinedTables(List<TileEntityBase> result) {
        return this.getJoinedTables(result, null);
    }

    public List<TileEntityBase> getJoinedTables(List<TileEntityBase> result, @Nullable EntityPlayer player) {
        BlockPos searchPosition;
        TreeMap<String, TileEntityBase> joinedTableMap = new TreeMap<String, TileEntityBase>();
        joinedTableMap.put(this.uuid, this);
        HashSet<BlockPos> searchedPositionSet = new HashSet<BlockPos>();
        searchedPositionSet.add(this.field_174879_c);
        ArrayDeque<BlockPos> toSearchQueue = new ArrayDeque<BlockPos>();
        toSearchQueue.offer(this.field_174879_c.func_177972_a(EnumFacing.NORTH));
        toSearchQueue.offer(this.field_174879_c.func_177972_a(EnumFacing.EAST));
        toSearchQueue.offer(this.field_174879_c.func_177972_a(EnumFacing.SOUTH));
        toSearchQueue.offer(this.field_174879_c.func_177972_a(EnumFacing.WEST));
        while ((searchPosition = (BlockPos)toSearchQueue.poll()) != null) {
            if (searchedPositionSet.contains(searchPosition)) continue;
            searchedPositionSet.add(searchPosition);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(searchPosition);
            if (!(tileEntity instanceof TileEntityBase)) continue;
            String key = ((TileEntityBase)tileEntity).uuid;
            if (joinedTableMap.containsKey(key)) {
                return Collections.emptyList();
            }
            if (player == null || ((TileEntityBase)tileEntity).canPlayerUse(player)) {
                joinedTableMap.put(key, (TileEntityBase)tileEntity);
            }
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.NORTH));
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.EAST));
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.SOUTH));
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.WEST));
        }
        result.addAll(joinedTableMap.values());
        return result;
    }

    @Nullable
    public TileEntityToolbox getAdjacentToolbox() {
        List<TileEntityBase> joinedTables = this.getJoinedTables(new ArrayList<TileEntityBase>());
        for (TileEntityBase joinedTable : joinedTables) {
            BlockPos pos = joinedTable.func_174877_v();
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(pos.func_177972_a(facing));
                if (tileEntity == null || !(tileEntity instanceof TileEntityToolbox)) continue;
                return (TileEntityToolbox)tileEntity;
            }
        }
        return null;
    }

    @Nullable
    public ITileEntityDesigner getAdjacentDesignersTable() {
        List<TileEntityBase> joinedTables = this.getJoinedTables(new ArrayList<TileEntityBase>());
        for (TileEntityBase joinedTable : joinedTables) {
            BlockPos pos = joinedTable.func_174877_v();
            TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
            if (tileEntity == null || !(tileEntity instanceof ITileEntityDesigner)) continue;
            return (ITileEntityDesigner)tileEntity;
        }
        return null;
    }

    public RecipeRegistry getWorktableRecipeRegistry() {
        return ArtisanAPI.getWorktableRecipeRegistry(this.getWorktableName());
    }

    public ItemStack getItemStackForTabDisplay(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        return new ItemStack(item, 1, block.func_176201_c(state));
    }

    public Container getContainer(InventoryPlayer inventoryPlayer, World world, IBlockState state, BlockPos pos) {
        return new Container(inventoryPlayer, world, this);
    }

    public int getMaximumDisplayedTabCount() {
        return 6;
    }

    protected abstract String getTableTitleKey();

    protected abstract ResourceLocation getGuiBackgroundTexture();

    protected abstract ObservableStackHandler createToolHandler();

    protected abstract CraftingMatrixStackHandler createCraftingMatrixHandler();

    protected abstract ObservableStackHandler createSecondaryOutputHandler();

    protected abstract int getFluidTankCapacity(EnumType var1);

    public abstract EnumTier getTier();
}

