/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.recipe.copy;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeBuilderException;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.RecipeBuilderInternal;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.copy.RecipeBuilderCopyStrategyBase;
import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTLogHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RecipeBuilderCopyStrategyByOutput
extends RecipeBuilderCopyStrategyBase {
    private IArtisanIngredient[] toCopy;

    public RecipeBuilderCopyStrategyByOutput(IArtisanIngredient[] toCopy) throws RecipeBuilderException {
        if (toCopy == null) {
            throw new RecipeBuilderException("Recipe ingredient to copy can't be null");
        }
        for (IArtisanIngredient ingredient : toCopy) {
            if (ingredient != null) continue;
            throw new RecipeBuilderException("Recipe ingredient to copy can't be null");
        }
        this.toCopy = toCopy;
    }

    @Override
    public void apply(RecipeBuilderInternal recipeBuilder, List<RecipeBuilderInternal> resultList) {
        try {
            Collection recipes = ForgeRegistries.RECIPES.getValuesCollection();
            HashSet<IRecipe> toCopy = new HashSet<IRecipe>();
            for (IRecipe recipe : recipes) {
                for (IArtisanIngredient copyRecipe : this.toCopy) {
                    if (recipe.func_77571_b().func_190926_b() || !copyRecipe.matches(recipe.func_77571_b())) continue;
                    toCopy.add(recipe);
                }
            }
            for (IRecipe recipe : toCopy) {
                this.doCopy(recipe, recipeBuilder.copy(), resultList);
            }
        }
        catch (Exception e) {
            CTLogHelper.logError((String)"Unable to copy and register recipe", (Throwable)e);
        }
    }
}

