/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.item;

import com.blamejared.ctgui.api.GuiBase;
import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.modules.worktables.Util;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ItemDesignPatternBakedModel
implements IBakedModel {
    private final IBakedModel delegate;

    public ItemDesignPatternBakedModel(IBakedModel delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = (TRSRTransformation)Util.getDefaultItemTransforms().get((Object)cameraTransformType);
        return Pair.of((Object)this, (Object)(transform == null ? Util.EMPTY_MATRIX_TRANSFORM : transform.getMatrix()));
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.delegate.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.delegate.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.delegate.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.delegate.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.delegate.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)this.delegate.func_188617_f().getOverrides()){

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                IArtisanRecipe recipe;
                String recipeName;
                NBTTagCompound tag = stack.func_77978_p();
                if (tag != null && !(recipeName = tag.func_74779_i("recipe")).isEmpty() && (recipe = ArtisanAPI.getRecipe(recipeName)) != null && ItemDesignPatternBakedModel.canDisplayPatternOutput(stack)) {
                    ItemStack output = recipe.getOutputWeightPairList().get(0).getOutput().toItemStack();
                    return Minecraft.func_71410_x().func_175599_af().func_184393_a(output, world, entity);
                }
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
    }

    private static boolean canDisplayPatternOutput(ItemStack stack) {
        return GuiBase.func_146272_n() || ItemDesignPatternBakedModel.isPatternInDisplaySlot(stack);
    }

    private static boolean isPatternInDisplaySlot(ItemStack stack) {
        return false;
    }
}

