/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei;

import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEICategoryBase;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEICategoryWorkshop;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEICategoryWorkstation;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEICategoryWorktable;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.PluginJEI;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import net.minecraft.util.ResourceLocation;

class JEICategoryFactory {
    private IGuiHelper guiHelper;

    JEICategoryFactory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    JEICategoryBase createCategory(String name, EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return new JEICategoryWorktable(name, tier, PluginJEI.createUID(name, tier), this.createTitleTranslateKey(name, tier), this.createBackground(name, tier, this.guiHelper), this.guiHelper);
            }
            case WORKSTATION: {
                return new JEICategoryWorkstation(name, tier, PluginJEI.createUID(name, tier), this.createTitleTranslateKey(name, tier), this.createBackground(name, tier, this.guiHelper), this.guiHelper);
            }
            case WORKSHOP: {
                return new JEICategoryWorkshop(name, tier, PluginJEI.createUID(name, tier), this.createTitleTranslateKey(name, tier), this.createBackground(name, tier, this.guiHelper), this.guiHelper);
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }

    private IDrawable createBackground(String name, EnumTier tier, IGuiHelper guiHelper) {
        if (tier == EnumTier.WORKTABLE) {
            ResourceLocation resourceLocation = new ResourceLocation("artisanworktables", String.format("textures/gui/worktable_%s.png", name));
            return guiHelper.createDrawable(resourceLocation, 3, 3, 170, 80);
        }
        if (tier == EnumTier.WORKSTATION) {
            ResourceLocation resourceLocation = new ResourceLocation("artisanworktables", String.format("textures/gui/workstation_%s.png", name));
            return guiHelper.createDrawable(resourceLocation, 3, 3, 170, 102);
        }
        if (tier == EnumTier.WORKSHOP) {
            ResourceLocation resourceLocation = new ResourceLocation("artisanworktables", String.format("textures/gui/workshop_%s.png", name));
            return guiHelper.createDrawable(resourceLocation, 3, 13, 170, 128);
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }

    private String createTitleTranslateKey(String name, EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return String.format("tile.artisanworktables.worktable.%s.name", name);
            }
            case WORKSTATION: {
                return String.format("tile.artisanworktables.workstation.%s.name", name);
            }
            case WORKSHOP: {
                return String.format("tile.artisanworktables.workshop.%s.name", name);
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }
}

