/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.tools.recipe;

import com.codetaylor.mc.artisanworktables.modules.tools.item.ItemWorktableTool;
import com.codetaylor.mc.artisanworktables.modules.tools.reference.EnumWorktableToolType;
import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModuleToolsRecipes {
    private static final EnumMap<EnumWorktableToolType, Object[]> RECIPE_MAP = new EnumMap(EnumWorktableToolType.class);
    private static final String MATERIAL_ALIAS = "#material_alias";

    public static void register(IForgeRegistry<IRecipe> registry, String modId, List<ItemWorktableTool> toolList) {
        RecipeItemParser recipeItemParser = new RecipeItemParser();
        for (ItemWorktableTool item : toolList) {
            try {
                String ingredient;
                String ingredientString = item.getMaterial().getIngredientString();
                ParseResult parseResult = recipeItemParser.parse(ingredientString);
                if (parseResult == ParseResult.NULL) {
                    throw new MalformedRecipeItemException("Unable to parse ingredient [" + item.getMaterial().getIngredientString() + "] for material [" + item.getMaterial() + "]");
                }
                if ("ore".equals(parseResult.getDomain())) {
                    ingredient = parseResult.getPath();
                } else {
                    Item parsedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parseResult.getDomain(), parseResult.getPath()));
                    if (parsedItem == null) {
                        throw new MalformedRecipeItemException("Unable to find registered item: " + parseResult.toString());
                    }
                    if (parseResult.getMeta() == Short.MAX_VALUE) {
                        throw new MalformedRecipeItemException("Wildcard value not accepted for tool material ingredients: " + parseResult.toString());
                    }
                    ingredient = new ItemStack(parsedItem, 1, parseResult.getMeta());
                }
                Object[] recipeDefinition = ModuleToolsRecipes.getRecipeDefinition(item.getType(), ingredient);
                if (recipeDefinition == null) {
                    throw new RuntimeException("Missing recipe definition for tool type: " + item.getType().getName());
                }
                ShapedOreRecipe recipe = new ShapedOreRecipe(null, (Item)item, recipeDefinition);
                recipe.setRegistryName(new ResourceLocation(modId, "recipe." + item.getName() + "." + item.getMaterial().getDataCustomMaterial().getName()));
                registry.register((IForgeRegistryEntry)recipe);
            }
            catch (Exception e) {
                throw new RuntimeException("Error registering recipe", e);
            }
        }
    }

    private static Object[] getRecipeDefinition(EnumWorktableToolType type, Object substitution) {
        Object[] objects = RECIPE_MAP.get((Object)type);
        if (objects == null) {
            throw new RuntimeException("Missing recipe definition for: " + (Object)((Object)type));
        }
        Object[] result = new Object[objects.length];
        System.arraycopy(objects, 0, result, 0, objects.length);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != MATERIAL_ALIAS) continue;
            result[i] = substitution;
        }
        return result;
    }

    static {
        RECIPE_MAP.put(EnumWorktableToolType.BLACKSMITHS_CUTTERS, new Object[]{". .", " x ", "s s", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.BLACKSMITHS_HAMMER, new Object[]{" .x", " s.", "s  ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.CARPENTERS_HAMMER, new Object[]{" ..", " sx", "s  ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.CARPENTERS_HANDSAW, new Object[]{" .s", ".s ", "s  ", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.JEWELERS_GEMCUTTER, new Object[]{"  x", " ..", "s  ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.JEWELERS_PLIERS, new Object[]{". .", "sxs", "s s", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.MASONS_CHISEL, new Object[]{"  .", " . ", "s  ", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.MASONS_TROWEL, new Object[]{"  .", " s.", "s  ", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.TAILORS_NEEDLE, new Object[]{"  .", " .x", "s  ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.TAILORS_SHEARS, new Object[]{" . ", "sx.", " s ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.ENGINEERS_DRIVER, new Object[]{"  .", " . ", "sx ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.ENGINEERS_SPANNER, new Object[]{" . ", " s.", "s  ", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.MAGES_ATHAME, new Object[]{"  .", "x. ", "sl ", Character.valueOf('l'), "gemLapis", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.MAGES_GRIMOIRE, new Object[]{" . ", "xbx", " . ", Character.valueOf('b'), Items.field_151122_aG, Character.valueOf('x'), "string", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.SCRIBES_COMPASS, new Object[]{" s ", "sxs", ". .", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.SCRIBES_QUILL, new Object[]{"  f", " .x", ".  ", Character.valueOf('x'), "string", Character.valueOf('f'), Items.field_151008_G, Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.CHEMISTS_BURNER, new Object[]{" . ", " . ", "ppp", Character.valueOf('p'), "plankWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.CHEMISTS_BEAKER, new Object[]{".g.", " g ", Character.valueOf('g'), "blockGlass", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.FARMERS_LENS, new Object[]{"   ", ".g.", "s  ", Character.valueOf('g'), "paneGlassColorless", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.FARMERS_SIFTER, new Object[]{"s.s", "sxs", "s.s", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.CHEFS_CUTTING_BOARD, new Object[]{"  s", " . ", ".bb", Character.valueOf('b'), "slabWood", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.CHEFS_PAN, new Object[]{"s  ", "c..", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.UNIVERSAL_MORTAR, new Object[]{"  s", ".f ", " . ", Character.valueOf('f'), Items.field_151145_ak, Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.UNIVERSAL_KNIFE, new Object[]{"  .", "x. ", "sx ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.TANNERS_PUNCH, new Object[]{"  .", " sx", ".x ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.TANNERS_GROOVER, new Object[]{". ", "s.", "w ", Character.valueOf('w'), "plankWood", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.POTTERS_CARVER, new Object[]{"  .", "xsx", ".  ", Character.valueOf('x'), "string", Character.valueOf('s'), "stickWood", Character.valueOf('.'), MATERIAL_ALIAS});
        RECIPE_MAP.put(EnumWorktableToolType.POTTERS_RAZOR, new Object[]{" . ", "x. ", "w  ", Character.valueOf('x'), "string", Character.valueOf('w'), "plankWood", Character.valueOf('.'), MATERIAL_ALIAS});
    }
}

