/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.tools.material;

import com.codetaylor.mc.artisanworktables.modules.tools.ModuleToolsConfig;
import com.codetaylor.mc.artisanworktables.modules.tools.material.DataCustomMaterial;
import com.codetaylor.mc.artisanworktables.modules.tools.material.DataCustomMaterialList;
import com.codetaylor.mc.athenaeum.reference.EnumMaterial;
import com.codetaylor.mc.athenaeum.util.StringHelper;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class DataCustomMaterialListFactory {
    public DataCustomMaterialList create() {
        ArrayList<DataCustomMaterial> list = new ArrayList<DataCustomMaterial>();
        for (EnumMaterial material : EnumMaterial.values()) {
            String ingredient;
            Color color = new Color(material.getColor());
            Object recipeIngredient = material.getRecipeIngredient();
            if (recipeIngredient instanceof String) {
                ingredient = "ore:" + recipeIngredient;
            } else {
                ResourceLocation resourceLocation = ((Item)recipeIngredient).getRegistryName();
                ingredient = resourceLocation.func_110624_b() + ":" + resourceLocation.func_110623_a();
            }
            list.add(new DataCustomMaterial(material.getName(), material.getToolMaterial().func_77996_d(), material.getToolMaterial().func_77997_a(), material.getToolMaterial().func_77998_b(), material.getToolMaterial().func_78000_c(), material.getToolMaterial().func_77995_e(), String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()), material.isHighlighted(), ingredient, "material.athenaeum." + material.getName().toLowerCase(), ModuleToolsConfig.TOOL_BY_MATERIAL_ORE_DICT_PREFIX + StringHelper.capitalizeFirstLetter((String)material.getName())));
        }
        return new DataCustomMaterialList(list);
    }
}

