/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.api.internal.recipe;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ISecondaryIngredientMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;

public class RecipeRegistry
extends IForgeRegistryEntry.Impl<RecipeRegistry> {
    private final List<IArtisanRecipe> recipeList;
    private final Map<String, IArtisanRecipe> recipeMap;

    public RecipeRegistry(String modId, String name) {
        this.setRegistryName(modId, name);
        this.recipeList = Collections.synchronizedList(new ArrayList());
        this.recipeMap = new HashMap<String, IArtisanRecipe>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IArtisanRecipe> getRecipeListByTier(EnumTier tier, List<IArtisanRecipe> result) {
        List<IArtisanRecipe> list = this.recipeList;
        synchronized (list) {
            for (IArtisanRecipe recipe : this.recipeList) {
                if (!recipe.matchTier(tier)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    @Nullable
    public IArtisanRecipe addRecipe(IArtisanRecipe recipe) {
        String recipeName = recipe.getName();
        if (this.recipeMap.containsKey(recipeName)) {
            LogManager.getLogger((String)ArtisanAPI.MOD_ID.get()).error("Duplicate recipe registration skipped: " + recipeName);
            return null;
        }
        this.recipeList.add(recipe);
        this.recipeMap.put(recipeName, recipe);
        return recipe;
    }

    public boolean hasRecipe(String recipeName) {
        return this.recipeMap.containsKey(recipeName);
    }

    @Nullable
    public IArtisanRecipe getRecipe(String recipeName) {
        return this.recipeMap.get(recipeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IArtisanRecipe findRecipe(int playerExperience, int playerLevels, boolean isPlayerCreative, ItemStack[] tools, ICraftingMatrixStackHandler craftingMatrix, @Nullable FluidStack fluidStack, ISecondaryIngredientMatcher secondaryIngredientMatcher, EnumTier tier, Map<ResourceLocation, IRequirementContext> requirementContextMap) {
        if (this.recipeList.isEmpty()) {
            return null;
        }
        List<IArtisanRecipe> list = this.recipeList;
        synchronized (list) {
            IArtisanRecipe lastRecipe = this.recipeList.get(this.recipeList.size() - 1);
            boolean lastRecipeMatches = lastRecipe.matches(requirementContextMap, playerExperience, playerLevels, isPlayerCreative, tools, craftingMatrix, fluidStack, secondaryIngredientMatcher, tier);
            if (lastRecipeMatches) {
                return lastRecipe;
            }
            for (int i = this.recipeList.size() - 2; i >= 0; --i) {
                IArtisanRecipe recipe = this.recipeList.get(i);
                boolean matches = recipe.matches(requirementContextMap, playerExperience, playerLevels, isPlayerCreative, tools, craftingMatrix, fluidStack, secondaryIngredientMatcher, tier);
                if (!matches) continue;
                this.recipeList.remove(i);
                this.recipeList.add(recipe);
                return recipe;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRecipeWithToolInSlot(ItemStack tool, int toolIndex) {
        List<IArtisanRecipe> list = this.recipeList;
        synchronized (list) {
            for (IArtisanRecipe recipe : this.recipeList) {
                if (!recipe.isValidTool(tool, toolIndex)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRecipeWithToolInAnySlot(ItemStack tool) {
        List<IArtisanRecipe> list = this.recipeList;
        synchronized (list) {
            for (IArtisanRecipe recipe : this.recipeList) {
                int toolCount = recipe.getToolCount();
                for (int i = 0; i < toolCount; ++i) {
                    if (!recipe.isValidTool(tool, i)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

