/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vazkii.quark.base.handler.OverrideRegistryHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.util.MutableVectorHolder;
import vazkii.quark.tweaks.block.BlockSpringySlime;

public class SpringySlime
extends Feature {
    public static BlockSpringySlime springySlime;
    private static final ThreadLocal<MutableVectorHolder> motionRecorder;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        springySlime = new BlockSpringySlime();
        springySlime.func_149663_c("slime");
        OverrideRegistryHandler.registerBlock((Block)springySlime, "slime");
    }

    public static void recordMotion(Entity entity) {
        SpringySlime.motionRecorder.get().x = entity.field_70159_w;
        SpringySlime.motionRecorder.get().y = entity.field_70181_x;
        SpringySlime.motionRecorder.get().z = entity.field_70179_y;
    }

    public static void onEntityCollision(Entity entity, double attemptedX, double attemptedY, double attemptedZ, double dX, double dY, double dZ) {
        if (!ModuleLoader.isFeatureEnabled(SpringySlime.class)) {
            return;
        }
        if (entity.func_70093_af() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
            return;
        }
        double height = entity.field_70131_O;
        double width = entity.field_70130_N;
        double minX = entity.field_70165_t - width / 2.0;
        double minY = entity.field_70163_u;
        double minZ = entity.field_70161_v - width / 2.0;
        double maxX = entity.field_70165_t + width / 2.0;
        double maxY = entity.field_70163_u + height;
        double maxZ = entity.field_70161_v + width / 2.0;
        if (attemptedX != dX) {
            SpringySlime.applyForAxis(entity, EnumFacing.Axis.X, minX, minY, minZ, maxX, maxY, maxZ, dX, attemptedX);
        }
        if (attemptedY != dY) {
            SpringySlime.applyForAxis(entity, EnumFacing.Axis.Y, minX, minY, minZ, maxX, maxY, maxZ, dY, attemptedY);
        }
        if (attemptedZ != dZ) {
            SpringySlime.applyForAxis(entity, EnumFacing.Axis.Z, minX, minY, minZ, maxX, maxY, maxZ, dZ, attemptedZ);
        }
    }

    private static double axial(EnumFacing.Axis axis, double we, double ud, double ns) {
        switch (axis) {
            case X: {
                return we;
            }
            case Y: {
                return ud;
            }
        }
        return ns;
    }

    private static void applyForAxis(Entity entity, EnumFacing.Axis axis, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double dV, double attemptedV) {
        double baseValue = dV < 0.0 ? SpringySlime.axial(axis, minX, minY, minZ) : SpringySlime.axial(axis, maxX, maxY, maxZ);
        double clampedAttempt = attemptedV;
        if (Math.abs(attemptedV) > Math.abs(dV) + 1.0) {
            clampedAttempt = dV + Math.signum(dV);
        }
        double v1 = baseValue + dV;
        double v2 = baseValue + clampedAttempt;
        double minV = Math.min(v1, v2);
        double maxV = Math.max(v1, v2);
        EnumFacing impactedSide = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(dV < 0.0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
        int lowXBound = (int)Math.floor(SpringySlime.axial(axis, minV, minX, minX));
        int highXBound = (int)Math.floor(SpringySlime.axial(axis, maxV, maxX, maxX));
        int lowYBound = (int)Math.floor(SpringySlime.axial(axis, minY, minV, minY));
        int highYBound = (int)Math.floor(SpringySlime.axial(axis, maxY, maxV, maxY));
        int lowZBound = (int)Math.floor(SpringySlime.axial(axis, minZ, minZ, minV));
        int highZBound = (int)Math.floor(SpringySlime.axial(axis, maxZ, maxZ, maxV));
        boolean restoredZ = false;
        for (BlockPos position : BlockPos.func_191531_b((int)lowXBound, (int)lowYBound, (int)lowZBound, (int)highXBound, (int)highYBound, (int)highZBound)) {
            restoredZ = SpringySlime.applyCollision(entity, position, impactedSide, restoredZ);
        }
    }

    private static boolean applyCollision(Entity entity, BlockPos position, EnumFacing impacted, boolean restoredMotion) {
        IBlockState state = entity.field_70170_p.func_180495_p(position);
        if (state.func_177230_c() instanceof BlockSlime) {
            if (impacted == EnumFacing.UP && entity instanceof EntityItem) {
                entity.field_70122_E = false;
            }
            switch (impacted.func_176740_k()) {
                case X: {
                    if (!restoredMotion) {
                        restoredMotion = true;
                        entity.field_70159_w = SpringySlime.motionRecorder.get().x;
                    }
                    entity.field_70159_w = Math.abs(entity.field_70159_w) * (double)impacted.func_82601_c();
                    if (entity instanceof EntityLivingBase) break;
                    entity.field_70159_w *= 0.8;
                    break;
                }
                case Y: {
                    if (!restoredMotion) {
                        restoredMotion = true;
                        entity.field_70181_x = SpringySlime.motionRecorder.get().y;
                    }
                    entity.field_70181_x = Math.abs(entity.field_70181_x) * (double)impacted.func_96559_d();
                    if (entity instanceof EntityLivingBase) break;
                    entity.field_70181_x *= 0.8;
                    break;
                }
                case Z: {
                    if (!restoredMotion) {
                        restoredMotion = true;
                        entity.field_70179_y = SpringySlime.motionRecorder.get().z;
                    }
                    entity.field_70179_y = Math.abs(entity.field_70179_y) * (double)impacted.func_82599_e();
                    if (entity instanceof EntityLivingBase) break;
                    entity.field_70179_y *= 0.8;
                }
            }
        }
        return restoredMotion;
    }

    static {
        motionRecorder = ThreadLocal.withInitial(MutableVectorHolder::new);
    }
}

