/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.Quark;

public final class OverrideRegistryHandler {
    private static void crackFinalField(Field field) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    private static Level revokeLog() {
        Level prior = FMLLog.log.getLevel();
        if (FMLLog.log instanceof Logger) {
            ((Logger)FMLLog.log).setLevel(Level.OFF);
        }
        return prior;
    }

    private static void restoreLog(Level level) {
        if (FMLLog.log instanceof Logger) {
            ((Logger)FMLLog.log).setLevel(level);
        }
    }

    public static void registerBlock(Block block, String baseName) {
        Level revoked = OverrideRegistryHandler.revokeLog();
        ResourceLocation regName = new ResourceLocation("minecraft", baseName);
        block.setRegistryName(regName);
        OverrideRegistryHandler.restoreLog(revoked);
        ProxyRegistry.register((IForgeRegistryEntry)block);
        for (Field declared : Blocks.class.getDeclaredFields()) {
            if (!Modifier.isStatic(declared.getModifiers()) || !declared.getType().isAssignableFrom(block.getClass())) continue;
            try {
                Block blockInField = (Block)declared.get(null);
                if (!regName.equals((Object)blockInField.getRegistryName())) continue;
                OverrideRegistryHandler.crackFinalField(declared);
                declared.set(null, block);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                Quark.LOG.warn("Was unable to replace registry entry for " + regName + ", may cause issues", (Throwable)e);
            }
        }
    }
}

