/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.items.DTToolGeneric;

public class DTPistonGlove
extends DTToolGeneric {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet();

    public DTPistonGlove(String name, Item.ToolMaterial material, float attackDamage, float attackSpeed) {
        super(name, material, attackDamage, attackSpeed, EFFECTIVE_ON);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return enchant == Enchantments.field_185307_s || enchant == Enchantments.field_185296_A;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.field_77862_b.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        BlockPos frontPos = new BlockPos(pos.func_177958_n() + facing.func_176734_d().func_82601_c(), pos.func_177956_o() + facing.func_176734_d().func_96559_d(), pos.func_177952_p() + facing.func_176734_d().func_82599_e());
        BlockPos backPos = new BlockPos(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!player.func_175151_a(pos, facing, player.func_184586_b(hand)) || world.func_175625_s(pos) != null) {
            return EnumActionResult.PASS;
        }
        if (player.func_184586_b(hand).func_77973_b() == DTItems.PISTONGLOVE && (world.func_175623_d(frontPos) || world.func_180495_p(frontPos).func_177230_c().func_176200_f((IBlockAccess)world, frontPos))) {
            this.pushBlock(player, world, pos, frontPos, hand);
            return EnumActionResult.SUCCESS;
        }
        if (player.func_184586_b(hand).func_77973_b() == DTItems.STICKYPISTONGLOVE && (world.func_175623_d(backPos) || world.func_180495_p(backPos).func_177230_c().func_176200_f((IBlockAccess)world, backPos))) {
            this.pullBlock(player, world, pos, backPos, hand);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void pushBlock(EntityPlayer player, World world, BlockPos pos, BlockPos frontPos, EnumHand hand) {
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_184811_cZ().func_185145_a(player.func_184586_b(hand).func_77973_b(), 20);
            player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
        }
        if (!world.field_72995_K) {
            world.func_175656_a(frontPos, world.func_180495_p(pos));
            world.func_175698_g(pos);
        }
        world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
        player.func_184609_a(hand);
    }

    public void pullBlock(EntityPlayer player, World world, BlockPos pos, BlockPos backPos, EnumHand hand) {
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_184811_cZ().func_185145_a(player.func_184586_b(hand).func_77973_b(), 20);
            player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
        }
        if (!world.field_72995_K) {
            world.func_175656_a(backPos, world.func_180495_p(pos));
            world.func_175698_g(pos);
        }
        world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
        player.func_184609_a(hand);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        float yaw = attacker.field_70177_z;
        float pitch = attacker.field_70125_A;
        float o = 0.6f;
        double motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * o;
        double motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * o;
        if (!target.func_130014_f_().field_72995_K) {
            target.field_70159_w = motionX;
            target.field_70181_x = 0.3;
            target.field_70179_y = motionZ;
            if (target instanceof EntityPlayer) {
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)target)));
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }
}

