/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.entities.projectiles;

import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pegbeard.dungeontactics.entities.projectiles.DTThrowableGeneric;
import pegbeard.dungeontactics.handlers.DTEffects;

public class DTEntityCryoGrenade
extends DTThrowableGeneric {
    public DTEntityCryoGrenade(World world) {
        super(world);
    }

    public DTEntityCryoGrenade(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public DTEntityCryoGrenade(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    @Override
    public void func_70071_h_() {
        IBlockState state = this.func_130014_f_().func_180495_p(this.func_180425_c());
        if (!this.func_130014_f_().field_72995_K) {
            if (--this.fuse <= 0) {
                if (this.cluster) {
                    this.dropBonus(this.func_130014_f_());
                    this.func_70106_y();
                }
                if (this.fuse <= 0) {
                    this.explode(this.func_130014_f_(), this.func_180425_c());
                    this.func_70106_y();
                }
            }
            if (state.func_177230_c() instanceof BlockLiquid && state.func_185904_a() == Material.field_151587_i || state.func_177230_c() == Blocks.field_150480_ab || this.func_70027_ad()) {
                this.fuse = 0;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            if (state.func_177230_c() instanceof BlockLiquid) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            } else {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
        super.func_70071_h_();
    }

    public void dropBonus(World world) {
        for (int i = 0; i < 5; ++i) {
            this.cluster = false;
            DTEntityCryoGrenade grenade = new DTEntityCryoGrenade(world);
            grenade.fuse = this.fuse;
            if (this.fuse <= 0) {
                grenade.fuse = world.field_73012_v.nextInt(10) + world.field_73012_v.nextInt(10);
            }
            grenade.func_70634_a(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
            grenade.func_70186_c(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat(), 0.3f, 0.1f);
            world.func_72838_d((Entity)grenade);
        }
    }

    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            if (!list.isEmpty()) {
                for (EntityLivingBase entitylivingbase : list) {
                    int amp;
                    double d0;
                    if (!entitylivingbase.func_184603_cC() || !((d0 = this.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                    double d1 = 4.0 - Math.sqrt(d0) / 4.0;
                    int j = (int)(d1 * 60.0 + 0.5);
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), (float)(j / 7) / 10.0f);
                    if (entitylivingbase.func_70660_b(MobEffects.field_76421_d) != null) {
                        amp = entitylivingbase.func_70660_b(MobEffects.field_76421_d).func_76458_c();
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, j, amp + 1));
                    } else {
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, j, 1));
                    }
                    if (entitylivingbase.func_70660_b(DTEffects.CRYO) != null) {
                        amp = entitylivingbase.func_70660_b(DTEffects.CRYO).func_76458_c();
                        entitylivingbase.func_70690_d(new PotionEffect(DTEffects.CRYO, j, amp + 1));
                        continue;
                    }
                    entitylivingbase.func_70690_d(new PotionEffect(DTEffects.CRYO, j, 1));
                }
            }
            if (world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                for (int i = 0; i < 5; ++i) {
                    this.killFish(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("cluster", this.cluster);
        tagCompound.func_74768_a("fuse", this.fuse);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.cluster = tagCompund.func_74767_n("cluster");
        this.fuse = tagCompund.func_74762_e("fuse");
    }
}

