/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.common.animation;

import com.leviathanstudio.craftstudio.common.animation.Channel;
import com.leviathanstudio.craftstudio.common.animation.CustomChannel;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.leviathanstudio.craftstudio.common.network.CSNetworkHelper;
import com.leviathanstudio.craftstudio.common.network.EnumIAnimatedEvent;
import com.leviathanstudio.craftstudio.common.network.IAnimatedEventMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public abstract class AnimationHandler<T extends IAnimated> {
    protected List<String> channelIds = new ArrayList<String>();

    public void addAnim(String modid, String animNameIn, String modelNameIn, boolean looped) {
        ResourceLocation anim = new ResourceLocation(modid, animNameIn);
        this.channelIds.add(anim.toString());
    }

    public void addAnim(String modid, String animNameIn, CustomChannel customChannelIn) {
        ResourceLocation anim = new ResourceLocation(modid, animNameIn);
        this.channelIds.add(anim.toString());
    }

    public void addAnim(String modid, String invertedAnimationName, String animationToInvert) {
        ResourceLocation anim = new ResourceLocation(modid, invertedAnimationName);
        this.channelIds.add(anim.toString());
    }

    public void startAnimation(String res, float startingFrame, T animatedElement) {
        if (animatedElement.isWorldRemote()) {
            this.clientStartAnimation(res, startingFrame, animatedElement);
        }
    }

    public void networkStartAnimation(String res, float startingFrame, T animatedElement, boolean clientSend) {
        if (animatedElement.isWorldRemote() == clientSend) {
            this.serverInitAnimation(res, startingFrame, animatedElement);
            CSNetworkHelper.sendIAnimatedEvent(new IAnimatedEventMessage(EnumIAnimatedEvent.START_ANIM, (IAnimated)animatedElement, this.getAnimIdFromName(res), startingFrame));
        }
    }

    protected abstract boolean clientStartAnimation(String var1, float var2, T var3);

    protected abstract boolean serverInitAnimation(String var1, float var2, T var3);

    protected abstract boolean serverStartAnimation(String var1, float var2, T var3);

    public void stopAnimation(String res, T animatedElement) {
        if (animatedElement.isWorldRemote()) {
            this.clientStopAnimation(res, animatedElement);
        }
    }

    public void networkStopAnimation(String res, T animatedElement, boolean clientSend) {
        if (animatedElement.isWorldRemote() == clientSend) {
            this.serverStopAnimation(res, animatedElement);
            CSNetworkHelper.sendIAnimatedEvent(new IAnimatedEventMessage(EnumIAnimatedEvent.STOP_ANIM, (IAnimated)animatedElement, this.getAnimIdFromName(res)));
        }
    }

    protected abstract boolean clientStopAnimation(String var1, T var2);

    protected abstract boolean serverStopAnimation(String var1, T var2);

    public void stopStartAnimation(String animToStop, String animToStart, float startingFrame, T animatedElement) {
        if (animatedElement.isWorldRemote()) {
            this.clientStopStartAnimation(animToStop, animToStart, startingFrame, animatedElement);
        }
    }

    public void networkStopStartAnimation(String animToStop, String animToStart, float startingFrame, T animatedElement, boolean clientSend) {
        if (animatedElement.isWorldRemote() == clientSend) {
            this.serverStopStartAnimation(animToStop, animToStart, startingFrame, animatedElement);
            CSNetworkHelper.sendIAnimatedEvent(new IAnimatedEventMessage(EnumIAnimatedEvent.STOP_START_ANIM, (IAnimated)animatedElement, this.getAnimIdFromName(animToStart), startingFrame, this.getAnimIdFromName(animToStop)));
        }
    }

    protected boolean clientStopStartAnimation(String animToStop, String animToStart, float startingFrame, T animatedElement) {
        boolean stopSucces = this.clientStopAnimation(animToStop, animatedElement);
        return this.clientStartAnimation(animToStart, startingFrame, animatedElement) && stopSucces;
    }

    protected boolean serverStopStartAnimation(String animToStop, String animToStart, float startingFrame, T animatedElement) {
        boolean stopSucces = this.serverStopAnimation(animToStop, animatedElement);
        return this.serverInitAnimation(animToStart, startingFrame, animatedElement) && stopSucces;
    }

    public abstract void animationsUpdate(T var1);

    public abstract boolean isAnimationActive(String var1, T var2);

    public abstract boolean isHoldAnimationActive(String var1, T var2);

    public abstract boolean canUpdateAnimation(Channel var1, T var2);

    public String getAnimNameFromId(short id) {
        return this.channelIds.get(id);
    }

    public short getAnimIdFromName(String name) {
        return (short)this.channelIds.indexOf(name);
    }

    public boolean onClientIAnimatedEvent(IAnimatedEventMessage message) {
        AnimationHandler<IAnimated> hand = message.animated.getAnimationHandler();
        switch (EnumIAnimatedEvent.getEvent(message.event)) {
            case START_ANIM: {
                return hand.clientStartAnimation(hand.getAnimNameFromId(message.animId), message.keyframeInfo, message.animated);
            }
            case STOP_ANIM: {
                return hand.clientStopAnimation(hand.getAnimNameFromId(message.animId), message.animated);
            }
            case STOP_START_ANIM: {
                return hand.clientStopStartAnimation(hand.getAnimNameFromId(message.optAnimId), hand.getAnimNameFromId(message.animId), message.keyframeInfo, message.animated);
            }
        }
        return false;
    }

    public static boolean onServerIAnimatedEvent(IAnimatedEventMessage message) {
        AnimationHandler<IAnimated> hand = message.animated.getAnimationHandler();
        switch (EnumIAnimatedEvent.getEvent(message.event)) {
            case START_ANIM: {
                return hand.serverInitAnimation(hand.getAnimNameFromId(message.animId), message.keyframeInfo, message.animated);
            }
            case ANSWER_START_ANIM: {
                return hand.serverStartAnimation(hand.getAnimNameFromId(message.animId), message.keyframeInfo, message.animated);
            }
            case STOP_ANIM: {
                hand.serverStopAnimation(hand.getAnimNameFromId(message.animId), message.animated);
                return true;
            }
            case STOP_START_ANIM: {
                hand.serverStopStartAnimation(hand.getAnimNameFromId(message.optAnimId), hand.getAnimNameFromId(message.animId), message.keyframeInfo, message.animated);
                return true;
            }
        }
        return false;
    }

    public void startAnimation(String modid, String animationName, T animatedElement) {
        this.startAnimation(modid, animationName, 0.0f, animatedElement);
    }

    public void startAnimation(String modid, String animationName, float startingFrame, T animatedElement) {
        this.startAnimation(modid + ":" + animationName, startingFrame, animatedElement);
    }

    public void networkStartAnimation(String modid, String animationName, T animatedElement) {
        this.networkStartAnimation(modid, animationName, 0.0f, animatedElement, false);
    }

    public void networkStartAnimation(String modid, String animationName, T animatedElement, boolean clientSend) {
        this.networkStartAnimation(modid, animationName, 0.0f, animatedElement, clientSend);
    }

    public void networkStartAnimation(String modid, String animationName, float startingFrame, T animatedElement, boolean clientSend) {
        this.networkStartAnimation(modid + ":" + animationName, startingFrame, animatedElement, clientSend);
    }

    public void stopAnimation(String modid, String animationName, T animatedElement) {
        this.stopAnimation(modid + ":" + animationName, animatedElement);
    }

    public void networkStopAnimation(String modid, String animationName, T animatedElement) {
        this.networkStopAnimation(modid + ":" + animationName, animatedElement, false);
    }

    public void networkStopAnimation(String modid, String animationName, T animatedElement, boolean clientSend) {
        this.networkStopAnimation(modid + ":" + animationName, animatedElement, clientSend);
    }

    public void stopStartAnimation(String modid, String animToStop, String animToStart, T animatedElement) {
        this.stopStartAnimation(modid + ":" + animToStop, modid + ":" + animToStart, 0.0f, animatedElement);
    }

    public void stopStartAnimation(String modid, String animToStop, String animToStart, float startingFrame, T animatedElement) {
        this.stopStartAnimation(modid + ":" + animToStop, modid + ":" + animToStart, startingFrame, animatedElement);
    }

    public void stopStartAnimation(String modid1, String animToStop, String modid2, String animToStart, float startingFrame, T animatedElement) {
        this.stopStartAnimation(modid1 + ":" + animToStop, modid2 + ":" + animToStart, startingFrame, animatedElement);
    }

    public void networkStopStartAnimation(String modid, String animToStop, String animToStart, T animatedElement) {
        this.networkStopStartAnimation(modid + ":" + animToStop, modid + ":" + animToStart, 0.0f, animatedElement, false);
    }

    public void networkStopStartAnimation(String modid, String animToStop, String animToStart, T animatedElement, boolean clientSend) {
        this.networkStopStartAnimation(modid + ":" + animToStop, modid + ":" + animToStart, 0.0f, animatedElement, clientSend);
    }

    public void networkStopStartAnimation(String modid, String animToStop, String animToStart, float startingFrame, T animatedElement, boolean clientSend) {
        this.networkStopStartAnimation(modid + ":" + animToStop, modid + ":" + animToStart, startingFrame, animatedElement, clientSend);
    }

    public void networkStopStartAnimation(String modid1, String animToStop, String modid2, String animToStart, float startingFrame, T animatedElement, boolean clientSend) {
        this.networkStopStartAnimation(modid1 + ":" + animToStop, modid2 + ":" + animToStart, startingFrame, animatedElement, clientSend);
    }

    public boolean isAnimationActive(String modid, String animationName, T animatedElement) {
        return this.isAnimationActive(modid + ":" + animationName, animatedElement);
    }

    public static class AnimInfo {
        public long prevTime;
        public float currentFrame;

        public AnimInfo(long prevTime, float currentFrame) {
            this.prevTime = prevTime;
            this.currentFrame = currentFrame;
        }
    }
}

