/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world;

import exterminatorjeff.undergroundbiomes.api.UBBiome;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.api.UndergroundBiomeSet;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.world.TraditionalStoneReplacer;
import exterminatorjeff.undergroundbiomes.world.UBBiomesSet;
import exterminatorjeff.undergroundbiomes.world.UBStoneReplacer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public final class WorldGenManager
implements UBStrataColumnProvider {
    private final UBLogger LOGGER;
    private final int dimensionID;
    private final UndergroundBiomeSet biomesSet;
    private UBStoneReplacer stoneReplacer;
    private boolean worldLoaded = false;
    private World world;
    private int seed;
    private BlockPos pos;
    private boolean hasChanged = false;
    private UBBiome currentBiome;

    public WorldGenManager(int dimensionID) {
        this.LOGGER = new UBLogger(WorldGenManager.class + " " + dimensionID, Level.INFO);
        this.LOGGER.debug("Dimension " + dimensionID + " will be UBified");
        this.dimensionID = dimensionID;
        this.biomesSet = new UBBiomesSet(UBConfig.SPECIFIC);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.world = event.getWorld();
        this.world.func_72860_G().func_75765_b();
        if (this.world.field_73011_w.getDimension() == this.dimensionID && !this.worldLoaded) {
            this.LOGGER.debug("Dimension " + this.dimensionID + " loaded");
            this.worldLoaded = true;
            this.seed = (int)this.world.func_72905_C();
            if (UBConfig.SPECIFIC.dimensionSpecificSeeds()) {
                this.seed += this.dimensionID;
            }
            this.stoneReplacer = new TraditionalStoneReplacer(this.seed, UBConfig.SPECIFIC.biomeSize(), this.biomesSet);
        }
    }

    private UBBiome blockBiomeValue(int xPos, int zPos) {
        return this.stoneReplacer.UBBiomeAt(xPos, zPos);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        if (event.getWorld().field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
            this.stoneReplacer.replaceStoneInChunk(chunk);
            this.stoneReplacer.redoOres(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        if (event.getWorld().field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            switch (event.getType()) {
                case GRANITE: 
                case DIORITE: 
                case ANDESITE: {
                    event.setResult(Event.Result.DENY);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void initMapGen(InitMapGenEvent event) {
        if (event.getType() == InitMapGenEvent.EventType.VILLAGE) {
            event.setNewGen((MapGenBase)new MapGenVillage(){

                public StructureStart func_75049_b(int chunkX, int chunkZ) {
                    WorldGenManager.this.LOGGER.debug("Village start in chunk: " + chunkX + ";" + chunkZ);
                    WorldGenManager.this.pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
                    WorldGenManager.this.hasChanged = true;
                    return super.func_75049_b(chunkX, chunkZ);
                }
            });
            event.setResult(Event.Result.DENY);
        }
    }

    @Override
    public UBStrataColumn strataColumn(int x, int z) {
        return this.stoneReplacer.strataColumn(x, z);
    }
}

