/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.core;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.core.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

@Mod(modid="undergroundbiomes", name="Underground Biomes", version="1.3.5", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class UndergroundBiomes {
    @Mod.Instance
    public static UndergroundBiomes INSTANCE;
    @SidedProxy(serverSide="exterminatorjeff.undergroundbiomes.core.ServerProxy", clientSide="exterminatorjeff.undergroundbiomes.core.ClientProxy")
    public static CommonProxy PROXY;
    private static final UBLogger LOGGER;
    public static boolean areBlocksAlreadyRegistered;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Start Pre-init!");
        PROXY.preInit(event);
        if (API.VERSION != "2.0.0") {
            throw new RuntimeException("Another mod has included an obsolete version of the Underground Biomes API.");
        }
        LOGGER.info("Pre-init done!");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        PROXY.registerBlocks(event);
        areBlocksAlreadyRegistered = true;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        PROXY.registerItems(event);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        PROXY.registerModels(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        PROXY.createRecipes(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROXY.init(event);
        LOGGER.info("Init done!");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws Exception {
        PROXY.postInit(event);
        LOGGER.info("Post-init done!");
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        PROXY.onServerStopped(event);
        LOGGER.info("Server Stopped");
    }

    static {
        LOGGER = new UBLogger(UndergroundBiomes.class, Level.INFO);
        areBlocksAlreadyRegistered = false;
    }
}

