/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.sheep;

import com.animania.Animania;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.interfaces.IMateable;
import com.animania.common.entities.sheep.EntityAnimaniaSheep;
import com.animania.common.entities.sheep.EntityLambBase;
import com.animania.common.entities.sheep.EntityRamBase;
import com.animania.common.entities.sheep.SheepType;
import com.animania.common.handler.BlockHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEweBase
extends EntityAnimaniaSheep
implements TOPInfoProviderMateable,
IMateable {
    protected ItemStack milk;
    public int dryTimer;
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntityEweBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_KIDS = EntityDataManager.func_187226_a(EntityEweBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntityEweBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntityEweBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityEweBase(World worldIn) {
        super(worldIn);
        this.milk = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)BlockHandler.fluidMilkSheep);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70130_N = 1.0f;
        this.field_70131_O = 1.0f;
        this.field_70138_W = 1.1f;
        this.gender = EntityGender.FEMALE;
        this.mateable = true;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        List list = this.field_70170_p.field_72996_f;
        int currentCount = 0;
        int num = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof EntityAnimaniaSheep)) continue;
            ++num;
        }
        currentCount = num;
        if (currentCount <= AnimaniaConfig.spawn.spawnLimitSheep) {
            int chooser = this.field_70146_Z.nextInt(5);
            if (chooser == 0) {
                EntityRamBase entitySheep = this.sheepType.getMale(this.field_70170_p);
                entitySheep.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entitySheep);
                entitySheep.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entitySheep.getPersistentID());
            } else if (chooser == 1 && !AnimaniaConfig.careAndFeeding.manualBreeding) {
                EntityLambBase entityKid = this.sheepType.getChild(this.field_70170_p);
                entityKid.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityKid);
                entityKid.setParentUniqueId(this.field_96093_i);
                this.setHasKids(true);
            } else if (chooser > 2) {
                EntityRamBase entityRam = this.sheepType.getMale(this.field_70170_p);
                entityRam.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityRam);
                entityRam.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityRam.getPersistentID());
                if (!AnimaniaConfig.careAndFeeding.manualBreeding) {
                    EntityLambBase entityKid = this.sheepType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityKid);
                    entityKid.setParentUniqueId(this.field_96093_i);
                    this.setHasKids(true);
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.265);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_KIDS, (Object)false);
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(200)));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Pregnant", this.getPregnant());
        compound.func_74757_a("HasKids", this.getHasKids());
        compound.func_74757_a("Fertile", this.getFertile());
        compound.func_74768_a("Gestation", this.getGestation());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPregnant(compound.func_74767_n("Pregnant"));
        this.setHasKids(compound.func_74767_n("HasKids"));
        this.setFertile(compound.func_74767_n("Fertile"));
        this.setGestation(compound.func_74762_e("Gestation"));
    }

    public int getGestation() {
        try {
            return this.getIntFromDataManager(GESTATION_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setGestation(int gestation) {
        this.field_70180_af.func_187227_b(GESTATION_TIMER, (Object)gestation);
    }

    @Override
    public boolean getPregnant() {
        try {
            return this.getBoolFromDataManager(PREGNANT);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setPregnant(boolean preggers) {
        if (preggers) {
            this.setGestation(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(200));
        }
        this.field_70180_af.func_187227_b(PREGNANT, (Object)preggers);
    }

    @Override
    public boolean getFertile() {
        try {
            return this.getBoolFromDataManager(FERTILE);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setFertile(boolean fertile) {
        this.field_70180_af.func_187227_b(FERTILE, (Object)fertile);
    }

    public boolean getHasKids() {
        try {
            return this.getBoolFromDataManager(HAS_KIDS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHasKids(boolean kids) {
        this.field_70180_af.func_187227_b(HAS_KIDS, (Object)kids);
    }

    protected SoundEvent func_184639_G() {
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = Animania.RANDOM.nextInt(num = happy == 2 ? 10 : (happy == 1 ? 20 : 40))) == 0) {
            return ModSoundEvents.sheepLiving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.sheepLiving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.sheepLiving3;
        }
        if (chooser == 3) {
            return ModSoundEvents.sheepLiving4;
        }
        if (chooser == 4) {
            return ModSoundEvents.sheepLiving5;
        }
        if (chooser == 5) {
            return ModSoundEvents.sheepLiving6;
        }
        if (chooser == 6) {
            return ModSoundEvents.sheepLiving7;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        int chooser = Animania.RANDOM.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.sheepHurt1;
        }
        return ModSoundEvents.sheepLiving7;
    }

    protected SoundEvent func_184615_bR() {
        int chooser = Animania.RANDOM.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.sheepHurt1;
        }
        return ModSoundEvents.sheepLiving7;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.getFertile() && this.dryTimer > -1) {
            --this.dryTimer;
        } else {
            this.setFertile(true);
            this.dryTimer = AnimaniaConfig.careAndFeeding.gestationTimer / 9 + this.field_70146_Z.nextInt(50);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 200 + this.field_70146_Z.nextInt(200);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntityRamBase> entities = AnimaniaHelper.getEntitiesInRange(EntityRamBase.class, 30.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                }
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        int gestationTimer = this.getGestation();
        if (gestationTimer > -1 && this.getPregnant()) {
            this.setGestation(--gestationTimer);
            if (gestationTimer == 0) {
                List list = this.field_70170_p.field_72996_f;
                int sheepCount = 0;
                int num = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityAnimaniaSheep)) continue;
                    ++num;
                }
                sheepCount = num;
                UUID MateID = this.getMateUniqueId();
                List<EntityRamBase> entities = AnimaniaHelper.getEntitiesInRange(EntityRamBase.class, 30.0, this.field_70170_p, (Entity)this);
                int esize = entities.size();
                Boolean mateFound = false;
                for (int k = 0; k <= esize - 1; ++k) {
                    EntityRamBase entity = entities.get(k);
                    if (entity == null || !this.getFed() || !this.getWatered() || !entity.getPersistentID().equals(MateID)) continue;
                    this.func_146082_f(null);
                    SheepType maleType = entity.sheepType;
                    SheepType babyType = SheepType.breed(maleType, this.sheepType);
                    EntityLambBase entityKid = babyType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityKid);
                    }
                    entityKid.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.lambLiving1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entity, (EntityAgeable)entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    k = esize;
                    mateFound = true;
                    break;
                }
                if (!mateFound.booleanValue() && this.getFed() && this.getWatered()) {
                    this.func_146082_f(null);
                    SheepType babyType = SheepType.breed(this.sheepType, this.sheepType);
                    EntityLambBase entityKid = babyType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityKid);
                    }
                    entityKid.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.lambLiving1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entityKid, (EntityAgeable)entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    mateFound = true;
                }
            }
        } else if (gestationTimer < 0) {
            this.setGestation(100);
        }
        super.func_70636_d();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack filled;
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (!this.getFed() || !this.getWatered() || stack == ItemStack.field_190927_a || !AnimaniaHelper.isEmptyFluidContainer(stack) || !this.getHasKids()) return super.func_184645_a(player, hand);
        player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
        ItemStack one = stack.func_77946_l();
        one.func_190920_e(1);
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)one, (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)this.milk.func_77946_l()), (int)1000, (EntityPlayer)player, (boolean)true);
        if (!result.success) {
            Item item = stack.func_77973_b();
            if (item == Items.field_151133_ar) {
                filled = this.milk.func_77946_l();
            } else {
                if (!Loader.isModLoaded((String)"ceramics") || item != Item.func_111206_d((String)"ceramics:clay_bucket")) return false;
                filled = new ItemStack(Item.func_111206_d((String)"ceramics:clay_bucket"), 1, 1);
            }
        } else {
            filled = result.result;
        }
        stack.func_190918_g(1);
        AnimaniaHelper.addItem(player, filled);
        this.setWatered(false);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70894_j(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 76 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70890_k(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 76) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && EntityAnimaniaSheep.TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            int bob;
            if (this.getMateUniqueId() != null) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
            }
            if (this.getHasKids()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.milkable"));
            }
            if (this.getFertile() && !this.getPregnant()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.fertile1"));
            }
            if (this.getPregnant()) {
                if (this.getGestation() > 0) {
                    bob = this.getGestation();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.pregnant2") + ")");
                } else {
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1"));
                }
            }
            if (this.func_70892_o()) {
                if (this.getWoolRegrowthTimer() > 1) {
                    bob = this.getWoolRegrowthTimer();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.wool1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.wool2") + ")");
                }
            } else if (!this.func_70892_o()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.wool3"));
            }
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }
}

