/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.recipes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.lib.Log;
import zabi.minecraft.extraalchemy.potion.PotionReference;
import zabi.minecraft.extraalchemy.recipes.brew.RecipeManager;
import zabi.minecraft.extraalchemy.recipes.crafting.ColorMedalRecipeHandler;
import zabi.minecraft.extraalchemy.recipes.crafting.QuickVialRecipeHandler;
import zabi.minecraft.extraalchemy.recipes.crafting.SplitPotionRecipeHandler;
import zabi.minecraft.extraalchemy.recipes.crafting.StickyPotionRecipeHandler;

@Mod.EventBusSubscriber
public class Recipes {
    private static int customRecipes = 0;

    public static void registerRecipes() {
        Recipes.loadCustomRecipes();
        if (ModConfig.potions.p_fuse) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151154_bQ), PotionReference.INSTANCE.TYPE_FUSE_NORMAL, PotionReference.INSTANCE.TYPE_FUSE_QUICK, PotionReference.INSTANCE.TYPE_FUSE_STRONG);
        }
        if (ModConfig.potions.p_magnetism) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151042_j), PotionReference.INSTANCE.TYPE_MAGNETISM_NORMAL, PotionReference.INSTANCE.TYPE_MAGNETISM_LONG, PotionReference.INSTANCE.TYPE_MAGNETISM_STRONG);
        }
        if (ModConfig.potions.p_piper) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151015_O), PotionReference.INSTANCE.TYPE_PIPER_NORMAL, PotionReference.INSTANCE.TYPE_PIPER_LONG, PotionReference.INSTANCE.TYPE_PIPER_STRONG);
        }
        if (ModConfig.potions.p_photosynthesis) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_185163_cU), PotionReference.INSTANCE.TYPE_PHOTOSYNTHESIS_NORMAL, PotionReference.INSTANCE.TYPE_PHOTOSYNTHESIS_LONG, PotionReference.INSTANCE.TYPE_PHOTOSYNTHESIS_STRONG);
        }
        if (ModConfig.potions.p_reincarnation) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185233_e, new ItemStack(Items.field_151116_aA), PotionReference.INSTANCE.TYPE_REINCARNATION_NORMAL, PotionReference.INSTANCE.TYPE_REINCARNATION_LONG, PotionReference.INSTANCE.TYPE_REINCARNATION_STRONG);
        }
        if (ModConfig.potions.p_dislocation) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185231_c, new ItemStack(Items.field_185161_cS), PotionReference.INSTANCE.TYPE_DISLOCATION_NORMAL, PotionReference.INSTANCE.TYPE_DISLOCATION_LONG, PotionReference.INSTANCE.TYPE_DISLOCATION_STRONG);
        }
        if (ModConfig.potions.p_combustion) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185231_c, new ItemStack(Item.func_150898_a((Block)Blocks.field_150402_ci)), PotionReference.INSTANCE.TYPE_COMBUSTION_NORMAL, PotionReference.INSTANCE.TYPE_COMBUSTION_LONG, PotionReference.INSTANCE.TYPE_COMBUSTION_STRONG);
        }
        if (ModConfig.potions.p_learning) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185232_d, new ItemStack(Item.func_150898_a((Block)Blocks.field_150368_y)), PotionReference.INSTANCE.TYPE_LEARNING_NORMAL, PotionReference.INSTANCE.TYPE_LEARNING_LONG, PotionReference.INSTANCE.TYPE_LEARNING_STRONG);
        }
        if (ModConfig.potions.p_gravity) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185232_d, new ItemStack(Items.field_151130_bT), PotionReference.INSTANCE.TYPE_GRAVITY_NORMAL, PotionReference.INSTANCE.TYPE_GRAVITY_LONG, PotionReference.INSTANCE.TYPE_GRAVITY_STRONG);
        }
        if (ModConfig.potions.p_crumbling) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185232_d, new ItemStack(Items.field_151145_ak), PotionReference.INSTANCE.TYPE_CRUMBLING_NORMAL, PotionReference.INSTANCE.TYPE_CRUMBLING_LONG, PotionReference.INSTANCE.TYPE_CRUMBLING_STRONG);
        }
        if (ModConfig.potions.p_recall) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185247_s, new ItemStack(Items.field_151061_bv), PotionReference.INSTANCE.TYPE_RECALL_NORMAL, PotionReference.INSTANCE.TYPE_RECALL_LONG, PotionReference.INSTANCE.TYPE_RECALL_STRONG);
        }
        if (ModConfig.potions.p_sinking) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185248_t, new ItemStack(Items.field_151119_aD), PotionReference.INSTANCE.TYPE_SINKING_NORMAL, PotionReference.INSTANCE.TYPE_SINKING_LONG, PotionReference.INSTANCE.TYPE_SINKING_STRONG);
        }
        if (ModConfig.potions.p_pacifism) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185253_y, new ItemStack(Items.field_151153_ao), PotionReference.INSTANCE.TYPE_PACIFISM_NORMAL, PotionReference.INSTANCE.TYPE_PACIFISM_LONG, PotionReference.INSTANCE.TYPE_PACIFISM_STRONG);
        }
        if (ModConfig.potions.p_hurry) {
            RecipeManager.registerRecipeWithVariant(PotionReference.INSTANCE.TYPE_CHARGED2, new ItemStack(Items.field_151106_aX), PotionReference.INSTANCE.TYPE_HURRY_NORMAL, PotionReference.INSTANCE.TYPE_HURRY_LONG, PotionReference.INSTANCE.TYPE_HURRY_STRONG);
        }
        if (ModConfig.potions.p_leech) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185252_x, new ItemStack(Items.field_151060_bw), PotionReference.INSTANCE.TYPE_LEECH_NORMAL, PotionReference.INSTANCE.TYPE_LEECH_LONG, PotionReference.INSTANCE.TYPE_LEECH_STRONG);
        }
        if (ModConfig.potions.p_sails) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185244_p, new ItemStack(Items.field_151115_aP), PotionReference.INSTANCE.TYPE_SAILS_NORMAL, PotionReference.INSTANCE.TYPE_SAILS_LONG, PotionReference.INSTANCE.TYPE_SAILS_STRONG);
        }
        if (ModConfig.potions.p_beheading) {
            RecipeManager.registerRecipeWithVariant(PotionReference.INSTANCE.TYPE_CHARGED2, new ItemStack(Items.field_151078_bh), PotionReference.INSTANCE.TYPE_BEHEADING_NORMAL, PotionReference.INSTANCE.TYPE_BEHEADING_LONG, PotionReference.INSTANCE.TYPE_BEHEADING_STRONG);
        }
        if (ModConfig.potions.p_pain) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185226_I, new ItemStack(Items.field_191525_da), PotionReference.INSTANCE.TYPE_PAIN_NORMAL, PotionReference.INSTANCE.TYPE_PAIN_LONG, PotionReference.INSTANCE.TYPE_PAIN_STRONG);
        }
        if (ModConfig.potions.p_push) {
            RecipeManager.registerRecipeWithVariant(PotionReference.INSTANCE.TYPE_PULL_NORMAL, new ItemStack(Items.field_151071_bq), PotionReference.INSTANCE.TYPE_PUSH_NORMAL, PotionReference.INSTANCE.TYPE_PUSH_LONG, PotionReference.INSTANCE.TYPE_PUSH_STRONG);
        }
        if (ModConfig.potions.p_pull) {
            RecipeManager.registerRecipeWithVariant(PotionTypes.field_185243_o, new ItemStack(Items.field_151074_bl), PotionReference.INSTANCE.TYPE_PULL_NORMAL, PotionReference.INSTANCE.TYPE_PULL_LONG, PotionReference.INSTANCE.TYPE_PULL_STRONG);
        }
        if (ModConfig.potions.p_concentration) {
            RecipeManager.registerRecipe(PotionTypes.field_185233_e, (PotionType)PotionReference.INSTANCE.TYPE_CONCENTRATION, Items.field_151110_aK);
        }
        if (ModConfig.potions.p_freezing) {
            RecipeManager.registerRecipe(PotionTypes.field_185233_e, (PotionType)PotionReference.INSTANCE.TYPE_FREEZING, Items.field_151126_ay);
        }
        if (ModConfig.potions.p_return) {
            RecipeManager.registerRecipe(PotionTypes.field_185233_e, (PotionType)PotionReference.INSTANCE.TYPE_RETURN, Items.field_179562_cC);
        }
        if (ModConfig.potions.p_cheatDeath) {
            RecipeManager.registerRecipe((PotionType)PotionReference.INSTANCE.TYPE_CHARGED2, (PotionType)PotionReference.INSTANCE.TYPE_CHEAT_DEATH, Items.field_151153_ao);
        }
        if (ModConfig.potions.p_dispel) {
            RecipeManager.registerRecipe((PotionType)PotionReference.INSTANCE.TYPE_LEARNING_STRONG, (PotionType)PotionReference.INSTANCE.TYPE_DISPEL, Items.field_151170_bI);
        }
        if (ModConfig.potions.p_charged_level2) {
            RecipeManager.registerRecipe((PotionType)PotionReference.INSTANCE.TYPE_CHARGED, (PotionType)PotionReference.INSTANCE.TYPE_CHARGED2, Items.field_179563_cD);
        }
        if (ModConfig.potions.p_charged_level1) {
            RecipeManager.registerRecipe(PotionTypes.field_185232_d, (PotionType)PotionReference.INSTANCE.TYPE_CHARGED, Items.field_151043_k);
        }
        if (ModConfig.options.breakingPotions) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("extraalchemy", "vial"), null, (ItemStack)new ItemStack(ModItems.vial_break, 3), (Object[])new Object[]{" F ", "G G", " G ", Character.valueOf('G'), Item.func_150898_a((Block)Blocks.field_150359_w), Character.valueOf('F'), Items.field_151145_ak});
        }
        if (ModConfig.options.enable_potion_bag) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("extraalchemy", "recipe_potion_bag"), null, (ItemStack)new ItemStack(ModItems.potion_bag), (Object[])new Object[]{" V ", "LWL", "LLL", Character.valueOf('V'), Items.field_151069_bo, Character.valueOf('W'), Item.func_150898_a((Block)Blocks.field_150486_ae), Character.valueOf('L'), Items.field_151116_aA});
        }
    }

    private static void loadCustomRecipes() {
        File file = new File(ExtraAlchemy.recipesfile);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return;
                }
                Recipes.initFile(file);
            }
            catch (IOException e) {
                Log.w("Cannot create custom recipe file");
                e.printStackTrace();
                return;
            }
        }
        Recipes.readFile(file);
    }

    private static void readFile(File file) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            in.lines().filter(s -> !s.startsWith("#")).forEach(s -> Recipes.parseString(s));
            Log.i(customRecipes + " custom recipes were added");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Log.w("Cannot read custom recipes file");
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void parseString(String s) {
        if (s.trim().length() == 0) {
            return;
        }
        try {
            Item ingItm;
            int amp = s.indexOf(38);
            int eql = s.indexOf(61);
            int cmm = s.indexOf(44);
            String spotin = s.substring(0, amp).trim();
            String spotout = s.substring(eql + 1, s.length()).trim();
            String ingredient_raw = s.substring(amp + 1, eql).trim();
            String item = "";
            int meta = 0;
            if (cmm < 0) {
                item = ingredient_raw;
            } else {
                item = s.substring(amp + 1, cmm).trim();
                meta = Integer.parseInt(s.substring(cmm + 1, eql).trim());
            }
            PotionType pin = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation(spotin));
            PotionType pout = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation(spotout));
            if (pin.equals(PotionTypes.field_185230_b) || pout.equals(PotionTypes.field_185230_b)) {
                Log.w("Input (" + spotin + ") or output (" + spotout + ") potion equals to water in " + s);
            }
            if (((ingItm = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(item))) == null || ingItm.equals(Items.field_190931_a)) && ((ingItm = Item.func_150898_a((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(item))))) == null || ingItm.equals(Items.field_190931_a))) {
                Log.e(item + " is not an existing item in " + s);
                return;
            }
            ItemStack req = new ItemStack(ingItm, 1, meta);
            if (req.func_190926_b()) {
                Log.e(item + " is not a valid item in " + s);
                return;
            }
            RecipeManager.registerRecipe(pin, pout, req);
            Log.i("Custom recipe found: " + pin.getRegistryName().toString() + " + " + req.toString() + " = " + pout.getRegistryName());
            ++customRecipes;
        }
        catch (Exception e) {
            Log.w(s + " is not a valid custom recipe");
            e.printStackTrace();
        }
    }

    private static void initFile(File file) {
        try {
            PrintWriter out = new PrintWriter(file);
            out.println("# Recipe format: potionIn&Itemstack,meta=potionOut");
            out.println("# If the item has no meta you can omit it: minecraft:awkward&minecraft:dirt=minecraft:water");
            out.println("# Example: minecraft:awkward&minecraft:dye,3=minecraft:strong_healing would take an awkward potion,");
            out.println("# cocoa (dye with metadata 3), and make a potion of healing II out of it.");
            out.println("# To log all existing potions set the \"log_potion_types\" config to true.");
            out.println("# To remove an existing potion recipe disable it in the config file.");
            out.println("# Lines starting with # and empty lines are ignored.");
            out.println("# There is no difference between \"minecraft:awkward&minecraft:dye,3=minecraft:strong_healing\" and \"minecraft:awkward & minecraft:dye,3 = minecraft:strong_healing\", spaces near delimiters are ignored");
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> evt) {
        IForgeRegistry reg = evt.getRegistry();
        reg.register((IForgeRegistryEntry)new ColorMedalRecipeHandler());
        if (ModConfig.options.allowPotionCombining) {
            reg.register((IForgeRegistryEntry)new StickyPotionRecipeHandler());
        }
        if (ModConfig.options.allowPotionSplitting) {
            reg.register((IForgeRegistryEntry)new SplitPotionRecipeHandler());
        }
        if (ModConfig.options.breakingPotions) {
            reg.register((IForgeRegistryEntry)new QuickVialRecipeHandler());
        }
    }
}

