/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.ModConfig;

public class ItemBreakablePotion
extends ItemPotion {
    protected ItemBreakablePotion() {
        this.func_77625_d(16);
        if (ModConfig.options.addSeparateTab) {
            this.func_77637_a(ExtraAlchemy.TAB);
        } else {
            this.func_77637_a(CreativeTabs.field_78038_k);
        }
        this.setRegistryName(new ResourceLocation("extraalchemy", "breakable_potion"));
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return I18n.func_135052_a((String)PotionUtils.func_185191_c((ItemStack)stack).func_185174_b("potion.effect."), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"item.breakable", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ArrayList list = new ArrayList();
        PotionUtils.func_185193_a((NBTTagCompound)stack.func_77978_p(), list);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            String s = I18n.func_135052_a((String)"effect.none", (Object[])new Object[0]).trim();
            tooltip.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = I18n.func_135052_a((String)potioneffect.func_76453_d(), (Object[])new Object[0]).trim();
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_135052_a((String)("potion.potency." + potioneffect.func_76458_c()), (Object[])new Object[0]).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f) + ")";
                }
                if (potion.func_76398_f()) {
                    tooltip.add(TextFormatting.RED + s1);
                    continue;
                }
                tooltip.add(TextFormatting.BLUE + s1);
            }
        }
        if (!list1.isEmpty()) {
            tooltip.add("");
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"potion.whenDrank", (Object[])new Object[0]));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (PotionType potiontype : PotionType.field_185176_a) {
                list.add((Object)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)this), (PotionType)potiontype));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            ArrayList list = new ArrayList();
            PotionUtils.func_185193_a((NBTTagCompound)player.func_184586_b(hand).func_77978_p(), list);
            for (PotionEffect potioneffect : list) {
                player.func_70690_d(new PotionEffect(potioneffect));
            }
        } else {
            Random rand = new Random();
            player.func_184609_a(hand);
            player.func_70669_a(player.func_184586_b(hand));
            world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 0.8f, 1.0f + rand.nextFloat(), false);
        }
        if (player != null && !player.field_71075_bZ.field_75098_d) {
            player.func_184586_b(hand).func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

