/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.blocks.BrewingStandFire;
import zabi.minecraft.extraalchemy.gui.GuiHandler;
import zabi.minecraft.extraalchemy.integration.BotaniaHandler;
import zabi.minecraft.extraalchemy.items.ItemSupporterMedal;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.items.TabExtraAlchemy;
import zabi.minecraft.extraalchemy.lib.Log;
import zabi.minecraft.extraalchemy.network.NetworkModRegistry;
import zabi.minecraft.extraalchemy.potion.PotionReference;
import zabi.minecraft.extraalchemy.potion.potion.PotionBeheading;
import zabi.minecraft.extraalchemy.potion.potion.PotionCheatDeath;
import zabi.minecraft.extraalchemy.potion.potion.PotionCombustion;
import zabi.minecraft.extraalchemy.potion.potion.PotionHurry;
import zabi.minecraft.extraalchemy.potion.potion.PotionLeech;
import zabi.minecraft.extraalchemy.potion.potion.PotionMagnetism;
import zabi.minecraft.extraalchemy.potion.potion.PotionPacifism;
import zabi.minecraft.extraalchemy.potion.potion.PotionPain;
import zabi.minecraft.extraalchemy.potion.potion.PotionReincarnation;
import zabi.minecraft.extraalchemy.proxy.Proxy;
import zabi.minecraft.extraalchemy.recipes.Recipes;
import zabi.minecraft.extraalchemy.recipes.brew.BrewingStandBlocker;
import zabi.minecraft.extraalchemy.recipes.crafting.StickyPotionRecipeHandler;

@Mod(name="Extra Alchemy", modid="extraalchemy", version="0.3.8.6.1-release", dependencies="after:botania", acceptedMinecraftVersions="[1.12,1.13)")
public class ExtraAlchemy {
    public static TabExtraAlchemy TAB;
    public static SimpleNetworkWrapper network;
    @SidedProxy(modId="extraalchemy", clientSide="zabi.minecraft.extraalchemy.proxy.ClientProxy", serverSide="zabi.minecraft.extraalchemy.proxy.ServerProxy")
    public static Proxy proxy;
    public static String recipesfile;
    @Mod.Instance
    public static ExtraAlchemy instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PotionReference.INSTANCE.getClass();
        proxy.registerEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)new PotionPacifism.PacifismHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionMagnetism.MagnetismHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionCheatDeath.PotionCheatDeathHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionReincarnation.PotionReincarnationHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionCombustion.PotionCombustionHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionLeech.PotionLeechHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionBeheading.PotionBeheadingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionPain.PotionPainHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BrewingStandBlocker());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (ModConfig.options.useFireUndernathBrewingStand) {
            MinecraftForge.EVENT_BUS.register((Object)new BrewingStandFire());
        }
        Log.i("Registering Network Protocol");
        NetworkModRegistry.registerMessages(network);
        proxy.registerItemDescriptions();
        recipesfile = event.getSuggestedConfigurationFile().getParent() + File.separatorChar + "extra_alchemy_recipes.cfg";
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BotaniaHandler.checkLoadBotania();
        Recipes.registerRecipes();
        proxy.registerColorHandler();
        if (ModConfig.options.addSeparateTab) {
            TAB = new TabExtraAlchemy();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig.ChangeListener());
        if (ModConfig.options.log_potion_types) {
            Log.i("\n\n\n-----------------------------v- LOGGING POTIONS -v-----------------------------\n\n\n");
            PotionType.field_185176_a.forEach(pt -> Log.i(pt.getRegistryName().toString()));
            Log.i("\n\n\n-----------------------------^- LOGGING POTIONS -^-----------------------------\n\n\n");
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand(new ICommand(){

            public int compareTo(ICommand arg0) {
                return 0;
            }

            public boolean func_82358_a(String[] args, int index) {
                return false;
            }

            public String func_71518_a(ICommandSender sender) {
                return "/ea-medal";
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
                return Lists.newArrayList();
            }

            public String func_71517_b() {
                return "ea-medal";
            }

            public List<String> func_71514_a() {
                return Lists.newArrayList((Object[])new String[]{"ea-medal"});
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (sender instanceof EntityPlayer) {
                    if (((ItemSupporterMedal)ModItems.supporter_medal).giveMedal((EntityPlayer)sender)) {
                        return;
                    }
                    throw new CommandException("You are not a registered contributor for Extra Alchemy!", new Object[0]);
                }
                throw new CommandException("Only players can execute this command", new Object[0]);
            }

            public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
                return true;
            }
        });
    }

    @Mod.EventHandler
    public void receiveIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (imcMessage.key.equalsIgnoreCase("sticky-blacklist")) {
                if (imcMessage.isStringMessage()) {
                    StickyPotionRecipeHandler.potionBlacklist.add(imcMessage.getStringValue());
                    Log.i(imcMessage.getStringValue() + " has been added to blacklist");
                    continue;
                }
                if (imcMessage.isItemStackMessage()) {
                    ItemStack is = imcMessage.getItemStackValue();
                    List listaEffetti = PotionUtils.func_185189_a((ItemStack)is);
                    if (listaEffetti.isEmpty()) {
                        Log.i(imcMessage.getSender() + " tried to blacklist a potion, but the itemstack has no effects");
                        continue;
                    }
                    if (listaEffetti.size() > 1) {
                        Log.i(imcMessage.getSender() + " tried to blacklist a potion, but the itemstack has more than one effect");
                        continue;
                    }
                    StickyPotionRecipeHandler.potionBlacklist.add(((PotionEffect)listaEffetti.get(0)).func_188419_a().func_76393_a());
                    Log.i(((PotionEffect)listaEffetti.get(0)).func_188419_a().func_76393_a() + " has been added to blacklist");
                    continue;
                }
                Log.i(imcMessage.getSender() + " tried to blacklist a potion, but only String and Itemstack messages are supported");
                continue;
            }
            if (imcMessage.key.equalsIgnoreCase("damage-blacklist")) {
                if (imcMessage.isStringMessage()) {
                    PotionCheatDeath.blacklist.add(imcMessage.getStringValue());
                    Log.i(imcMessage.getStringValue() + " has been added to damage blacklist");
                    continue;
                }
                Log.i(imcMessage.getSender() + " tried to blacklist a damage source, but it is not a string. Use damageSourceObj.damageType");
                continue;
            }
            if (!imcMessage.key.equalsIgnoreCase("hurry-blacklist")) continue;
            if (imcMessage.isStringMessage()) {
                PotionHurry.blacklist.add(imcMessage.getStringValue());
                Log.i(imcMessage.getStringValue() + " has been added to hurry blacklist");
                continue;
            }
            Log.i(imcMessage.getSender() + " tried to blacklist an ITicking entity, but it is not a string. Use TileEntityClass.getName()");
        }
    }

    static {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("extraalchemy");
    }
}

