/*
 * Decompiled with CFR 0.152.
 */
package omtteam.ompd.blocks;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.api.block.IHasItemBlock;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.ompd.OpenModularPassiveDefense;
import omtteam.ompd.init.ModBlocks;
import omtteam.ompd.items.blocks.ItemBlockHardened;
import omtteam.ompd.tileentity.TileEntityTiered;
import omtteam.ompd.util.BlockHelper;

public class BlockHardened
extends BlockAbstractTileEntity
implements IHasItemBlock {
    private static final PropertyInteger TIER = PropertyInteger.func_177719_a((String)"tier", (int)1, (int)5);

    public BlockHardened() {
        super(Material.field_151576_e);
        this.func_149647_a(OpenModularPassiveDefense.modularPassiveDefenseTab);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 2);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(1)));
        this.func_149663_c("hardened");
        this.setRegistryName("ompd", "hardened");
    }

    public ItemBlock getItemBlock(Block block) {
        return new ItemBlockHardened(block);
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityTiered();
    }

    public boolean func_149662_c(IBlockState blockState) {
        return true;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(meta + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TIER});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.hardened, 1, (Integer)state.func_177229_b((IProperty)TIER) - 1);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return BlockHelper.onBlockActivated(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockHelper.onBlockPlacedByTiered(worldIn, pos, state, placer, stack, (Block)this);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        switch ((Integer)blockState.func_177229_b((IProperty)TIER)) {
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 20.0f;
            }
            case 3: {
                return 30.0f;
            }
            case 4: {
                return 50.0f;
            }
            case 5: {
                return 80.0f;
            }
        }
        return 10.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        switch ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)TIER)) {
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 20.0f;
            }
            case 3: {
                return 30.0f;
            }
            case 4: {
                return 50.0f;
            }
            case 5: {
                return 80.0f;
            }
        }
        return 10.0f;
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 5; ++i) {
            items.add((Object)new ItemStack(ModBlocks.hardened, 1, i));
        }
    }
}

