/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.structure.io;

import com.zeitheron.hammercore.utils.structure.io.StructureElement;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.minecraft.util.math.BlockPos;

public class StructureInputStream
implements Closeable,
AutoCloseable {
    public final DataInputStream in;
    private boolean hasMore = false;

    public StructureInputStream(InputStream stream) throws IOException {
        this.in = new DataInputStream(new GZIPInputStream(stream));
        this.hasMore = this.in.readBoolean();
    }

    public StructureElement read() throws IOException {
        if (!this.in.readBoolean()) {
            return null;
        }
        String block = this.string();
        byte meta = this.in.readByte();
        String nbt = this.string();
        String[] pos = this.string().split(" ");
        this.hasMore = this.in.readBoolean();
        return new StructureElement(block, meta, nbt, new BlockPos(Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2])));
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    private String string() throws IOException {
        byte[] buf = new byte[this.in.readInt()];
        this.in.read(buf);
        return new String(buf);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

