/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class NetUtil {
    public static final int BYTE_ARRAY_START = 1;
    public static final int BYTE_ARRAY_END = 2;
    public static final int BLOCK_POS_START = 3;
    public static final int BLOCK_POS_END = 4;

    public static void writeByteArray(byte[] b, ByteBuf buf) {
        if (b == null || buf == null) {
            return;
        }
        buf.writeInt(1);
        buf.writeInt(b.length);
        buf.writeBytes(b);
        buf.writeInt(2);
    }

    public static byte[] readByteArray(ByteBuf buf) {
        if (buf.readInt() == 1) {
            byte[] bytes = new byte[buf.readInt()];
            buf.readBytes(bytes);
            return (byte[])(buf.readInt() == 2 ? bytes : null);
        }
        return null;
    }

    public static NBTTagCompound readCompound(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static void writeCompound(ByteBuf buf, NBTTagCompound nbt) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static ItemStack readStack(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static void writeStack(ByteBuf buf, ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
    }

    public static void writeBlockPos(BlockPos pos, ByteBuf buf) {
        if (pos == null) {
            return;
        }
        buf.writeInt(3);
        buf.writeLong(pos.func_177986_g());
        buf.writeInt(4);
    }

    public static BlockPos loadBlockPos(ByteBuf buf) {
        if (buf.readInt() != 3) {
            return null;
        }
        BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
        return buf.readInt() == 4 ? pos : null;
    }
}

